/**
 * 
 */
package org.eaglei.datatools.etl.utils;

import java.util.Arrays;

import org.apache.log4j.Logger;
import org.eaglei.model.EIURI;

/**
 * This class is for deleting instances which ETled from particular file, -f takes filename as input ,this is the file name which we want to delete all instances ETLed from .-r takes repository configuration file path
 * 
 * FLOW : deleteInsntaceETledFromFIle(String) takes file name as input ,it then calls getResourcesOfFile(String) where it builds query to ge the Instance URI's we want to delete,It builds the query by calling
 * SPARQLQueryUtil.getInstance().getResourcesETLedFromFileQuery(fileName); .We query repository using the query which we built it then returns results in xml format ,xml is parsed for Instance URIs in ETLSPARQLQueryUtil.getInstanceURI(resources)
 * method ,which returns array if instance URI's . instanceURI array is then passed to deleteInsntaceETledFromFIle(String) where it will be deleted one by one by looping throught he array
 * 
 * @author Sravan Kumar Cheriyala
 * 
 */
public class DeETL extends BulkOperation {

	private static org.apache.log4j.Logger logger = Logger.getLogger( DeETL.class );
	private static String fileName;
	private static String repo;

	public static void main(String args[]) throws Exception {

		for (int i = 0; i < args.length - 1; i++) {
			if ( args[i].equals( "-f" ) ) {
				i = i + 1;
				fileName = args[i];
			} else if ( args[i].equals( "-r" ) ) {
				i = i + 1;
				repo = args[i];
			}

		}

		DeETL deetl = new DeETL( repo );
		deetl.deleteInstanceETLedFromFile( fileName );
		logger.info( "delete complete" );

	}

	/**
	 * Constructor where we get the ReposiotryProvider object and also gets session by loging into reposiotry
	 * 
	 * @throws Exception
	 */
	public DeETL(String repo) throws Exception {

		super( repo );
	}

	/**
	 * Delete the instances which are ETLed from fileName
	 * */
	public int deleteInstanceETLedFromFile(String fileName) throws Exception {
		/* fetch the resources ETLed from file */
		String[] instanceURIAry = getResourcesOfFile( fileName );
		int i = 0;
		for (String instaceURI : instanceURIAry) {
			try {
				/* delete instances one by one */
				this.getRdftorepo().getRepositoryProvider().claim( this.getRdftorepo().getSession(), Arrays.asList( EIURI.create( instaceURI ) ) );
				logger.info( "deleting " + instaceURI );
				this.getRdftorepo().getRepositoryProvider().deleteInstance( this.getRdftorepo().getSession(), EIURI.create( instaceURI ) );
				i++;
				if ( i % 50 == 0 ) {
					System.gc();
				}
			} catch (Exception e) {
				logger.error( "There is Error in deleting this resource" + instaceURI );
				continue;
			}

		}
		if ( i == 0 ) {
			logger.info( "There are no resources with this file to delete" );
		}
		return i;

	}

}
