/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.User;
import org.eaglei.datatools.config.DatatoolsConfiguration;
import org.eaglei.datatools.etl.server.ETLRepositoryConfiguration;
import org.eaglei.datatools.etl.server.loader.Loader;
import org.eaglei.datatools.jena.RESTRepositoryProvider;
import org.eaglei.datatools.jena.RepositorySecurityProvider;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.datatools.status.RepositoryProviderException;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIInstanceFactory;
import org.eaglei.security.Session;

public class RepoService {
    private static RepoService instance = null;
    private DatatoolsConfiguration config;
    RESTRepositoryProvider repoProvider;
    RepositorySecurityProvider securityProvider;
    JenaEIInstanceFactory instanceFactory;
    private static final String DEFAULT_CONFIGURATION = "etl-datatools.prop";
    private static final Log logger = LogFactory.getLog(RepoService.class);
    private String token;
    private Session session;
    private final String repoConfigFile;
    public static final EIEntity DEFAULT_CREATE_TRANSITION = EIEntity.create((EIURI)EIURI.create((String)"http://eagle-i.org/ont/repo/1.0/WFT_0"), (String)"Default Create");
    public static final EIEntity SENT_TO_CURATION_TRANSITION = EIEntity.create((EIURI)EIURI.create((String)"http://eagle-i.org/ont/repo/1.0/WFT_1"), (String)"Send to Curation");
    public static final EIEntity PUBLISH_TRANSITION = EIEntity.create((EIURI)EIURI.create((String)"http://eagle-i.org/ont/repo/1.0/WFT_2"), (String)"Publish");

    private RepoService(String file, JenaEIInstanceFactory instanceFactory) throws IOException {
        this.instanceFactory = instanceFactory;
        this.config = this.getConfiguration(file);
        this.repoConfigFile = file;
        this.repoProvider = new RESTRepositoryProvider(instanceFactory);
        this.securityProvider = RepositorySecurityProvider.getInstance();
    }

    private RepoService(JenaEIInstanceFactory instanceFactory) throws IOException, URISyntaxException {
        this.instanceFactory = instanceFactory;
        this.config = this.getConfiguration();
        this.repoConfigFile = "";
        this.repoProvider = new RESTRepositoryProvider(instanceFactory);
        this.securityProvider = RepositorySecurityProvider.getInstance();
    }

    public RepositoryProvider getRepositoryProvider() {
        return this.repoProvider;
    }

    public RepositorySecurityProvider getRepositorySecurityProvider() {
        return this.securityProvider;
    }

    public DatatoolsConfiguration getDatatoolsConfiguration() {
        return this.config;
    }

    public static RepoService getInstance(String file, JenaEIInstanceFactory instanceFactory) throws Exception {
        if (instance == null) {
            instance = new RepoService(file, instanceFactory);
            instance.login(file);
        }
        return instance;
    }

    public boolean workFlowTansistion(EIURI resource, Loader.Promote promote) throws Exception {
        if (promote == Loader.Promote.PUBLISH) {
            this.repoProvider.transition(this.getSession(), Arrays.asList(resource), SENT_TO_CURATION_TRANSITION);
            this.repoProvider.claim(this.getSession(), Arrays.asList(resource));
            this.repoProvider.transition(this.getSession(), Arrays.asList(resource), PUBLISH_TRANSITION);
            return true;
        }
        if (promote == Loader.Promote.CURATION) {
            this.repoProvider.transition(this.getSession(), Arrays.asList(resource), DEFAULT_CREATE_TRANSITION);
            this.repoProvider.transition(this.getSession(), Arrays.asList(resource), SENT_TO_CURATION_TRANSITION);
            this.repoProvider.release(this.getSession(), Arrays.asList(resource));
            return true;
        }
        if (promote == Loader.Promote.DRAFT) {
            this.repoProvider.release(this.getSession(), Arrays.asList(resource));
            return true;
        }
        return false;
    }

    public boolean workFlowTansistion(List<EIURI> lstResource, Loader.Promote promote) throws Exception {
        if (promote == Loader.Promote.PUBLISH) {
            this.repoProvider.transition(this.getSession(), lstResource, SENT_TO_CURATION_TRANSITION);
            this.repoProvider.claim(this.getSession(), lstResource);
            this.repoProvider.transition(this.getSession(), lstResource, PUBLISH_TRANSITION);
            this.repoProvider.release(this.getSession(), lstResource);
            return true;
        }
        if (promote == Loader.Promote.CURATION) {
            this.repoProvider.transition(this.getSession(), lstResource, DEFAULT_CREATE_TRANSITION);
            this.repoProvider.transition(this.getSession(), lstResource, SENT_TO_CURATION_TRANSITION);
            this.repoProvider.release(this.getSession(), lstResource);
            return true;
        }
        if (promote == Loader.Promote.DRAFT) {
            this.repoProvider.release(this.getSession(), lstResource);
            return true;
        }
        return false;
    }

    public static RepoService getInstance(JenaEIInstanceFactory instanceFactory) throws Exception {
        if (instance == null) {
            instance = new RepoService(instanceFactory);
        }
        return instance;
    }

    public boolean pushToRepo(Model rdfModel, Session session, String uri, String promoteParameter) throws Exception {
        StringWriter swriter = new StringWriter();
        rdfModel.write((Writer)swriter, "RDF/XML");
        this.repoProvider.createInstance(session, swriter.toString(), uri, RESTRepositoryProvider.DEFAULT_WORKSPACE_ENTITY);
        this.token = this.repoProvider.updateInstance(session, swriter.toString(), uri, null);
        this.repoProvider.updateInstance(session, swriter.toString(), uri, this.token);
        return true;
    }

    public boolean pushToRepo(EIInstance instance) throws Exception {
        this.repoProvider.createInstance(this.getSession(), instance, RepositoryProvider.DEFAULT_WORKSPACE_ENTITY);
        return true;
    }

    public boolean pushToRepo(String rdfString, String instanceUri) throws RepositoryProviderException {
        this.repoProvider.createInstance(this.session, rdfString, instanceUri, RepositoryProvider.DEFAULT_WORKSPACE_ENTITY);
        return true;
    }

    public String query(String query) throws Exception {
        return this.repoProvider.query(this.getSession(), query);
    }

    public List<EIURI> getNewInstancesFromRepo(int countofInstances) {
        try {
            return this.repoProvider.getNewInstanceID(this.getSession(), countofInstances);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setPropertyFilePathAndgetNewRepoProvider(String configFilePath) throws IOException {
        File configFile = new File(configFilePath);
        logger.debug((Object)("loading configuration file: " + configFile));
        this.config = new DatatoolsConfiguration(configFile);
        this.securityProvider.setDefaultRepository(this.config.getDatatoolsRepositoryURL());
    }

    private DatatoolsConfiguration getConfiguration(String DEFAULT_CONFIGURATION) {
        try {
            File configFile = new File(DEFAULT_CONFIGURATION);
            logger.debug((Object)("loading configuration file: " + configFile));
            return new DatatoolsConfiguration(configFile);
        }
        catch (Exception e) {
            logger.error((Object)("Error loading configuration from " + DEFAULT_CONFIGURATION + " " + e));
            throw new RuntimeException(e);
        }
    }

    private DatatoolsConfiguration getConfiguration() throws IOException, URISyntaxException {
        URL configURL = this.getClass().getClassLoader().getResource(DEFAULT_CONFIGURATION);
        if (configURL == null) {
            logger.error((Object)"Could not locate etl-datatools.prop on classpath");
            throw new FileNotFoundException("Could not locate etl-datatools.prop on classpath");
        }
        try {
            File configFile = new File(configURL.toURI());
            logger.debug((Object)("loading configuration file: " + configFile));
            return new DatatoolsConfiguration(configFile);
        }
        catch (RuntimeException e) {
            logger.error((Object)("Error loading configuration from etl-datatools.prop " + e));
            throw new RuntimeException(e);
        }
    }

    public Session login(String repoPath) throws Exception {
        Map<String, String> credentialMap = ETLRepositoryConfiguration.getCredentialsForRepo(repoPath);
        User strAry = this.securityProvider.login(credentialMap.get("user"), credentialMap.get("password"));
        if (strAry == null) {
            logger.error((Object)"Could not authenticate please check username,password and Repository URL...Exiting System");
            System.exit(2);
        }
        this.setSession(strAry.getSession());
        return this.getSession();
    }

    public Resource getNewResourceFromRepository(Model modelTocreateStatments) {
        List<EIURI> lstNewURI = this.getNewInstancesFromRepo(1);
        Resource subject = modelTocreateStatments.createResource(lstNewURI.get(0).toString());
        return subject;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public String getRepoConfigFile() {
        return this.repoConfigFile;
    }
}

