/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server.extractor.parsers;

import java.util.HashMap;
import java.util.Map;
import org.eaglei.datatools.etl.server.extractor.parsers.Data;

public class RowIterator {
    private int indexVariable = 0;
    private Data data;
    private final int COLUMN_NAME = 0;
    private final int COLUMN_VALUE = 1;

    public RowIterator(Data data) {
        this.data = data;
        this.indexVariable = 0;
    }

    public boolean hasNext() {
        if (this.indexVariable <= this.data.getRowCount() - 1) {
            ++this.indexVariable;
            return true;
        }
        return false;
    }

    public Map<String, String> nextRow() {
        HashMap<String, String> columnMap = new HashMap<String, String>();
        int row = this.indexVariable - 1;
        int columnCount = this.data.getColumnCount();
        for (int i = 0; i <= columnCount - 1; ++i) {
            String[] columnData = (String[])this.data.getValueAt(row, i);
            if (columnData == null) continue;
            columnMap.put(columnData[0].toUpperCase(), columnData[1]);
        }
        return columnMap;
    }
}

