/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server.extractor.parsers.excelparsers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.eaglei.datatools.etl.server.extractor.parsers.Data;
import org.eaglei.datatools.etl.server.extractor.parsers.EIFileParser;
import org.eaglei.datatools.etl.server.extractor.parsers.MapFileConfiguration;
import org.eaglei.datatools.etl.server.extractor.parsers.excelparsers.ExcelTemplateConfiguration;
import org.eaglei.datatools.etl.server.extractor.parsers.excelparsers.FileMetaData;
import org.eaglei.datatools.excel.ExcelParserException;
import org.eaglei.datatools.excel.ExcelUtils;

public class ExcelFileParser
extends EIFileParser<Map<String, Data>> {
    private static Logger logger = Logger.getLogger(ExcelFileParser.class);
    private static String FORM_VERSION_STRING = "FORM VERSION";
    private final Map<String, Integer> numberOfRowsReadFromTabs = new HashMap<String, Integer>();
    private String mapsParentDirecotryPath;
    private String[] globalColumnsOrderInExcel;
    private String[] globalColumnsOrderInCSV;
    private boolean globalColumns;
    private Sheet LAB_SHEET;
    private final ExcelFileMetaData fileMetaData = new ExcelFileMetaData();
    private final Workbook excelWorkbook;

    public ExcelFileParser(File excelFile) {
        this.excelWorkbook = this.getWorkbookOfExcel(excelFile);
        for (int sheetNum = 0; sheetNum <= this.excelWorkbook.getNumberOfSheets() - 1; ++sheetNum) {
            if (this.excelWorkbook.isSheetHidden(sheetNum)) continue;
            Sheet sheet = this.excelWorkbook.getSheetAt(sheetNum);
            String sheetName = sheet.getSheetName();
            try {
                this.fileMetaData.sheetNameToSheetMetaData.put(sheetName, this.readSheetMetaData(sheet));
                continue;
            }
            catch (ParseException e) {
                logger.error((Object)("parse exception for the sheet" + sheetName));
                logger.info((Object)("ignoring the sheet " + sheetName));
            }
        }
    }

    public List<Sheet> getSheets() {
        ArrayList<Sheet> listToReturn = new ArrayList<Sheet>();
        for (int i = 0; i <= this.excelWorkbook.getNumberOfSheets(); ++i) {
            listToReturn.add(this.excelWorkbook.getSheetAt(i));
        }
        return listToReturn;
    }

    public FileMetaData getFileMetaData() throws ParseException {
        return this.fileMetaData;
    }

    @Override
    public Map<String, Data> parse(File mapDirectory) throws ConfigurationException, IOException, ParseException {
        HashMap<String, Data> ExcelTabNameToTabDataMap = new HashMap<String, Data>();
        this.LAB_SHEET = this.getLabSheet();
        ExcelFileMetaData fileMetaData = (ExcelFileMetaData)this.getFileMetaData();
        this.readConfigPropertiesOfFile(mapDirectory.getPath());
        if (this.globalColumnsOrderInExcel != null && this.globalColumnsOrderInExcel.length > 1) {
            this.globalColumns = true;
        }
        HashMap<String, String> globalColumnsHash = new HashMap<String, String>();
        String[] configuredTabToProcess = MapFileConfiguration.getOrderofMapFiles(mapDirectory.getPath());
        for (int sheetNum = 0; sheetNum <= this.excelWorkbook.getNumberOfSheets() - 1; ++sheetNum) {
            if (this.excelWorkbook.isSheetHidden(sheetNum)) continue;
            Sheet sheet = this.excelWorkbook.getSheetAt(sheetNum);
            String sheetName = sheet.getSheetName();
            boolean isConfiguredSheet = false;
            for (String configuredTab : configuredTabToProcess) {
                if (!configuredTab.equalsIgnoreCase(sheetName)) continue;
                isConfiguredSheet = true;
            }
            if (!isConfiguredSheet) continue;
            SheetMetaData sheetMetaData = fileMetaData.getSheetMetaData(sheetName);
            if (sheet == null) {
                logger.info((Object)(sheetName + " is not present in excel tab ...continuing onto next tab"));
                continue;
            }
            logger.info((Object)("Reading " + sheet.getSheetName()));
            int rowcount = sheet.getLastRowNum();
            if (rowcount == 0) {
                logger.info((Object)"no Rows in sheet...ignoring");
                continue;
            }
            if (sheet.getRow(1) == null) continue;
            int colcount = sheet.getRow(1).getLastCellNum();
            int startRow = 0;
            int endRow = 0;
            boolean rowheadStart = false;
            endRow = sheet.getPhysicalNumberOfRows();
            TabConfigProperites properties = this.readConfigPropertiesForTab(sheet, mapDirectory.getPath());
            startRow = properties.getStartRow();
            Data tabData = new Data(1, colcount + 4);
            if (this.globalColumns && !sheet.getSheetName().equalsIgnoreCase("lab")) {
                tabData.setColumnCount(tabData.getColumnCount() + this.globalColumnsOrderInCSV.length + 1);
            }
            --startRow;
            int rowCount = 0;
            while (startRow <= endRow - 1) {
                Row row = sheet.getRow(startRow);
                if (row == null) {
                    ++startRow;
                    continue;
                }
                if (ExcelUtils.isBlankRow(row)) {
                    ++startRow;
                    continue;
                }
                tabData.setRowCount(rowCount + 1);
                Iterator cellIter = row.cellIterator();
                int colNum = 0;
                for (int tempLoop = 0; cellIter.hasNext() && tempLoop < colcount; ++tempLoop) {
                    Cell cell = (Cell)cellIter.next();
                    if (sheet.getSheetName().equalsIgnoreCase("lab") && this.globalColumns && tempLoop <= this.globalColumnsOrderInExcel.length - 1) {
                        globalColumnsHash.put(this.globalColumnsOrderInExcel[tempLoop], cell.getStringCellValue());
                    }
                    int rowNum = rowCount;
                    colNum = this.globalColumns && rowNum >= 0 && this.globalColumnsOrderInExcel[0] != null && !sheet.getSheetName().equalsIgnoreCase("lab") ? cell.getColumnIndex() + this.globalColumnsOrderInCSV.length : cell.getColumnIndex();
                    String columnName = this.evaluateColumnNameWhenGolobalColumnPreset(colNum, sheetMetaData);
                    this.addCell((DefaultTableModel)tabData, cell, rowNum, colNum, columnName);
                }
                this.addGlobalColumnsToRow(globalColumnsHash, sheetMetaData, 0, tabData, startRow, rowCount);
                ++startRow;
                ++rowCount;
            }
            this.numberOfRowsReadFromTabs.put(sheet.getSheetName(), rowCount);
            ExcelTabNameToTabDataMap.put(sheet.getSheetName().toUpperCase(), tabData);
        }
        return ExcelTabNameToTabDataMap;
    }

    public Sheet getLabSheet() {
        Sheet LAB_SHEET = this.excelWorkbook.getSheet("lab");
        return LAB_SHEET;
    }

    private void addGlobalColumnsToRow(HashMap<String, String> globalColumnsHash, SheetMetaData sheetMetaData, int rowheadStart, Data tabData, int startRow, int rowCount) throws UnsupportedEncodingException {
        block3: {
            block4: {
                if (!this.globalColumns || this.globalColumnsOrderInExcel[0] == null || sheetMetaData.getSheetName().equalsIgnoreCase("lab")) break block3;
                if (startRow != rowheadStart || this.globalColumnsOrderInExcel.length <= 0) break block4;
                int y = 0;
                for (String globalValue : this.globalColumnsOrderInCSV) {
                    this.addCell((DefaultTableModel)tabData, globalValue, rowCount, y, globalValue);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("adding global row at " + rowCount + " and column" + y + "the value is " + globalValue));
                    }
                    ++y;
                }
                break block3;
            }
            if (startRow <= rowheadStart || globalColumnsHash == null) break block3;
            int y = 0;
            for (String strColumn : this.globalColumnsOrderInCSV) {
                this.addCell((DefaultTableModel)tabData, globalColumnsHash.get(strColumn).toString(), rowCount, y, strColumn);
                logger.debug((Object)("adding global row at " + rowCount + " and column" + y + "the value is " + strColumn));
                ++y;
            }
        }
    }

    private Workbook getWorkbookOfExcel(File excelFile) {
        Workbook wb;
        try {
            wb = WorkbookFactory.create((InputStream)new FileInputStream(excelFile));
        }
        catch (FileNotFoundException e) {
            throw new ExcelParserException(e);
        }
        catch (InvalidFormatException e) {
            logger.error((Object)("Expecting an Excel file.." + (Object)((Object)e) + "Ignoring...."));
            throw new ExcelParserException(e);
        }
        catch (IOException e) {
            logger.error((Object)("IOExpecting an Excel file.." + e + "Ignoring...."));
            throw new ExcelParserException(e);
        }
        return wb;
    }

    protected String readMapDirectoryPathFromFile() throws ParseException {
        return this.readMapDirectoryPathFromFile(this.LAB_SHEET);
    }

    private String readMapDirectoryPathFromFile(Sheet sheet) throws ParseException {
        return this.mapsParentDirecotryPath + "/" + this.getFormVersion(sheet);
    }

    public String getFormVersion(Sheet sheet) throws ParseException {
        String mapDirectoryName = "";
        String mapDirectoryVersion = "";
        boolean formVersionColumnFound = false;
        Row headerow = this.getHeaderRow(sheet);
        Iterator cellIter = headerow.cellIterator();
        int cellNum = 0;
        while (cellIter.hasNext()) {
            Row valueRow;
            Cell valuecell;
            Cell cell = (Cell)cellIter.next();
            if (cell.getStringCellValue().contains(FORM_VERSION_STRING)) {
                mapDirectoryName = cell.getStringCellValue().split(FORM_VERSION_STRING)[0].toLowerCase().trim();
                formVersionColumnFound = true;
            }
            if (formVersionColumnFound && !(valuecell = (valueRow = sheet.getRow(headerow.getRowNum() + 1)).getCell(cellNum)).getStringCellValue().equals("")) {
                mapDirectoryVersion = valuecell.getStringCellValue().toLowerCase();
                break;
            }
            ++cellNum;
        }
        return mapDirectoryName + "_" + mapDirectoryVersion;
    }

    private Row getHeaderRow(Sheet sheet) throws ParseException {
        double endRow = 0.0;
        int k = 0;
        endRow = sheet.getPhysicalNumberOfRows();
        while ((double)k <= endRow - 1.0) {
            Row row = sheet.getRow(k);
            if (row == null) {
                ++k;
                continue;
            }
            Iterator cellIter = row.cellIterator();
            while (cellIter.hasNext()) {
                Cell cell = (Cell)cellIter.next();
                if (cell.getCellType() != 1 || !cell.getStringCellValue().contains(FORM_VERSION_STRING)) continue;
                return row;
            }
            ++k;
        }
        throw new ParseException("Header row not found in this Excel File", 0);
    }

    public SheetMetaData readSheetMetaData(Sheet sheet) throws ParseException {
        HashMap<String, Integer> columnNameToNumberMap = new HashMap<String, Integer>();
        HashMap<Integer, String> columnNumberToNameMap = new HashMap<Integer, String>();
        SheetMetaData sheetMetaData = new SheetMetaData();
        int i = 1;
        if (this.globalColumns && !sheet.getSheetName().equalsIgnoreCase("lab")) {
            for (String globalColumnName : this.globalColumnsOrderInCSV) {
                columnNameToNumberMap.put(globalColumnName, i);
                ++i;
            }
        }
        Row headerow = this.getHeaderRow(sheet);
        Iterator cellIter = headerow.cellIterator();
        while (cellIter.hasNext()) {
            Cell cell = (Cell)cellIter.next();
            columnNameToNumberMap.put(cell.getStringCellValue(), i);
            columnNumberToNameMap.put(i, cell.getStringCellValue());
            ++i;
        }
        sheetMetaData.columnNameToColumnNumberMap = columnNameToNumberMap;
        sheetMetaData.columnNumberToColumnNameMap = columnNumberToNameMap;
        sheetMetaData.sheetName = sheet.getSheetName();
        return sheetMetaData;
    }

    protected void readConfigPropertiesOfFile(String mapDirectoryPath) throws IOException, ConfigurationException {
        Map<String, String> rowConfigMap = ExcelTemplateConfiguration.getFormatingInfoOfFile(mapDirectoryPath);
        String order = rowConfigMap.get("order");
        if (rowConfigMap.get("globalcolumnsorderinexcel") != null) {
            this.globalColumnsOrderInExcel = rowConfigMap.get("globalcolumnsorderinexcel").split("#");
        }
        if (rowConfigMap.get("globalcolumnsorderintoCSV") != null) {
            this.globalColumnsOrderInCSV = rowConfigMap.get("globalcolumnsorderintoCSV").split("#");
        }
    }

    protected TabConfigProperites readConfigPropertiesForTab(Sheet sheet, String mapDirecotryPath) throws ConfigurationException {
        Map<String, String> rowConfigMap = ExcelTemplateConfiguration.getFormatingInfoOfRow(mapDirecotryPath, sheet.getSheetName());
        int startRow = Integer.parseInt(rowConfigMap.get("startrow"));
        return new TabConfigProperites(startRow, sheet.getSheetName());
    }

    private void addCell(DefaultTableModel tableModel, Cell cell, int rowNum, int colNum, String columnName) throws UnsupportedEncodingException {
        if (cell.getCellType() == 1 || cell.getCellType() == 2 || cell.getCellType() == 4) {
            this.addCell(tableModel, cell.getStringCellValue(), rowNum, colNum, columnName);
        } else if (cell.getCellType() == 0) {
            this.addCell(tableModel, (int)cell.getNumericCellValue() + "", rowNum, colNum, columnName);
        }
    }

    private void addCell(DefaultTableModel tableModel, String cellValue, int rowNum, int colNum, String columnName) throws UnsupportedEncodingException {
        String columnValue = new String(cellValue.replaceAll("_x[^_]*?_", "").getBytes(), "utf-8");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("adding in the cell column name = " + columnName + "  column value = " + columnValue));
        }
        String[] cellData = new String[]{columnName.trim().replaceAll("\\s+", "_"), columnValue};
        tableModel.setValueAt(cellData, rowNum, colNum);
    }

    private String evaluateColumnNameWhenGolobalColumnPreset(int colNum, SheetMetaData sheetMetaData) {
        int keyTofetchColumnNameFromMap = 0;
        keyTofetchColumnNameFromMap = !sheetMetaData.getSheetName().equalsIgnoreCase("lab") && this.globalColumns ? Math.abs(colNum - this.globalColumnsOrderInCSV.length) : colNum;
        return sheetMetaData.getColumnNameByColumnNumber(keyTofetchColumnNameFromMap + 1);
    }

    public Map<String, Integer> getNumberOfRowsReadFromTabs() {
        return this.numberOfRowsReadFromTabs;
    }

    public FileMetaData getMetaData() {
        return this.fileMetaData;
    }

    public class SheetMetaData {
        private Map<String, Integer> columnNameToColumnNumberMap;
        private Map<Integer, String> columnNumberToColumnNameMap;
        private String sheetName;

        public int getColumnNumberByColumnName(String columnName) {
            return this.columnNameToColumnNumberMap.get(columnName);
        }

        public Map<String, Integer> getMapofColumnNameAndNumber() {
            return this.columnNameToColumnNumberMap;
        }

        public Map<Integer, String> getColumnNumberToColumnNameMap() {
            return this.columnNumberToColumnNameMap;
        }

        public String getColumnNameByColumnNumber(Integer columnNumber) {
            return this.columnNumberToColumnNameMap.get(columnNumber);
        }

        public String getSheetName() {
            return this.sheetName;
        }
    }

    public class ExcelFileMetaData
    implements FileMetaData {
        private final Map<String, SheetMetaData> sheetNameToSheetMetaData = new HashMap<String, SheetMetaData>();

        public SheetMetaData getSheetMetaData(String sheetName) {
            return this.sheetNameToSheetMetaData.get(sheetName);
        }
    }

    private class TabConfigProperites {
        int startRow;
        String tabName;

        TabConfigProperites(int startRow, String tabName) {
            this.startRow = startRow;
            this.tabName = tabName;
        }

        public int getStartRow() {
            return this.startRow;
        }

        public String getTabName() {
            return this.tabName;
        }
    }
}

