/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server.transformer;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.ETLEntryPoint;
import org.eaglei.datatools.etl.server.RepoService;
import org.eaglei.datatools.etl.server.transformer.Expression;
import org.eaglei.datatools.etl.server.transformer.MapInterpreter;
import org.eaglei.datatools.etl.server.transformer.SemiColonExpresson;
import org.eaglei.datatools.etl.utils.ETLUtils;
import org.eaglei.datatools.model.AnnotationFormModel;

public class EmbeddedExpression
extends Expression<Statement[]> {
    private static Logger logger = Logger.getLogger(EmbeddedExpression.class);
    public static final String EMBEDDED_CLASS_EXPRESSION_MATCHER = "Ex:emb";
    private String embeddedExpression;
    private Map<String, String> columnMap;
    private Statement mapStatement;
    private Model mapModel;
    private AnnotationFormModel anntModel;
    private RepoService repoService;

    public EmbeddedExpression(String embeddedExpression, Map<String, String> columnMap, Statement mapStatement, Model mapModel, AnnotationFormModel anntModel, RepoService repoService) {
        this.embeddedExpression = embeddedExpression;
        this.columnMap = columnMap;
        this.mapStatement = mapStatement;
        this.mapModel = mapModel;
        this.anntModel = anntModel;
        this.repoService = repoService;
    }

    @Override
    public Statement[] interpret() {
        try {
            Model subNodeModel = ETLUtils.getsubModelByExpression(this.embeddedExpression, this.mapModel);
            SemiColonExpresson semiColonExpression = new SemiColonExpresson(subNodeModel, this.columnMap);
            Model[] modelAfterSemiColonInterpretation = semiColonExpression.interpret();
            ArrayList<Statement> statementList = new ArrayList<Statement>();
            for (Model model : modelAfterSemiColonInterpretation) {
                MapInterpreter subNodeMapEvaluator = new MapInterpreter(this.mapModel, model, this.columnMap, this.embeddedExpression, this.mapStatement, this.anntModel, this.repoService);
                Statement[] statementAry = subNodeMapEvaluator.interpret();
                if (statementAry == null || statementAry.length <= 1 || !ETLUtils.isLabelPresentInMap(statementAry)) continue;
                Resource subject = ETLEntryPoint.getInstance().getRepoService().getNewResourceFromRepository(subNodeModel);
                List<Statement> returnedstatementList = ETLUtils.replaceExpressionWithURI(statementAry, subject, this.embeddedExpression);
                Statement statementOfMainInstance = subNodeModel.createStatement(this.mapStatement.getSubject(), this.mapStatement.getPredicate(), (RDFNode)subject);
                returnedstatementList.add(statementOfMainInstance);
                statementList.addAll(returnedstatementList);
            }
            return statementList.toArray(new Statement[statementList.size()]);
        }
        catch (IOException ioe) {
            logger.error((Object)"IO Exception Occured in interpret method of EmbeddedClassExpression class");
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public String getExpressionString() {
        return EMBEDDED_CLASS_EXPRESSION_MATCHER;
    }

    @Override
    public Statement getExpressionStatement() {
        return this.mapStatement;
    }
}

