/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server.transformer;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eaglei.datatools.etl.server.RepoService;
import org.eaglei.datatools.etl.server.exceptions.TransformException;
import org.eaglei.datatools.etl.server.transformer.MapInterpreter;
import org.eaglei.datatools.etl.server.transformer.MapInterpreterTracker;
import org.eaglei.datatools.etl.server.transformer.Transformer;
import org.eaglei.datatools.model.AnnotationFormModel;

public class TransformerImpl
implements Transformer {
    private final AnnotationFormModel annotationFormModel;
    private final RepoService repoService;
    private final Model mapModel;

    public TransformerImpl(AnnotationFormModel model, RepoService repoService, File mapFile) throws FileNotFoundException {
        this.annotationFormModel = model;
        this.repoService = repoService;
        FileInputStream mapStream = new FileInputStream(mapFile);
        Model mapModel = ModelFactory.createDefaultModel();
        mapModel.read((InputStream)mapStream, "RDF/XML");
        mapModel.removeNsPrefix("");
        this.mapModel = mapModel;
    }

    @Override
    public Statement[] transformToRDF(Map<String, String> columnMap) throws TransformException {
        try {
            MapInterpreterTracker.getInstance().getMapOfExpressionStringToResourceURI().clear();
            MapInterpreter mapInterpretor = new MapInterpreter(this.mapModel, columnMap, this.annotationFormModel, this.repoService);
            Statement[] stmtAry = mapInterpretor.interpret();
            return stmtAry;
        }
        catch (IOException ioe) {
            throw new TransformException(ioe);
        }
    }
}

