/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.utils;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JFrame;

public class BasicUtils {
    private static final Random RAND = new Random();

    public static String getFileAsString(String fn) throws IOException, FileNotFoundException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(fn)));
        return BasicUtils.getStringFromBufferedReader(reader);
    }

    public static String getURLAsString(URL theURL) throws IOException {
        if (theURL == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(theURL.openStream()));
        return BasicUtils.getStringFromBufferedReader(reader);
    }

    public static URL encode(URL theURL) {
        try {
            String aURLString = theURL.toExternalForm();
            aURLString = aURLString.replaceAll(" ", "%20");
            theURL = new URL(aURLString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return theURL;
    }

    public static String getStringFromBufferedReader(BufferedReader aReader) throws IOException {
        StringBuffer theFile = new StringBuffer();
        String line = aReader.readLine();
        while (line != null) {
            theFile.append(line + "\n");
            line = aReader.readLine();
        }
        aReader.close();
        return theFile.toString();
    }

    public static void saveStringToFile(String toSave, String fn) throws IOException, FileNotFoundException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fn)));
        StringTokenizer st = new StringTokenizer(toSave, "\n", true);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals("\n")) {
                writer.newLine();
                continue;
            }
            writer.write(s);
        }
        writer.flush();
        writer.close();
    }

    public static String getRandomString() {
        return BasicUtils.getRandomString(15);
    }

    public static String getRandomString(int numChars) {
        int chars = RAND.nextInt(numChars);
        while (chars == 0) {
            chars = RAND.nextInt(numChars);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < chars; ++i) {
            int index = 97 + RAND.nextInt(26);
            char c = (char)index;
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isValidURL(String s) {
        try {
            new URL(s);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isFileURL(String s) {
        return BasicUtils.isValidURL(s) && s.startsWith("file:");
    }

    public static boolean isInArray(int elem, int[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != elem) continue;
            return true;
        }
        return false;
    }

    public static String convertStringToUnicodeString(String s) throws Exception {
        StringBuffer convert = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            int ch = s.charAt(i);
            if ((byte)ch >= 0 && ch <= 255) {
                convert.append((char)ch);
                continue;
            }
            if (ch > 255 || ch < 0) {
                throw new Exception("Invalid Character: " + (char)ch);
            }
            String val = "\\u";
            int intVal = ch;
            int bit4 = (int)((double)intVal / Math.pow(16.0, 3.0));
            intVal = (int)((double)intVal - (double)bit4 * Math.pow(16.0, 3.0));
            int bit3 = (int)((double)intVal / Math.pow(16.0, 2.0));
            intVal = (int)((double)intVal - (double)bit3 * Math.pow(16.0, 2.0));
            int bit2 = (int)((double)intVal / Math.pow(16.0, 1.0));
            intVal = (int)((double)intVal - (double)bit2 * Math.pow(16.0, 1.0));
            int bit1 = (int)((double)intVal / Math.pow(16.0, 0.0));
            if ((intVal = (int)((double)intVal - (double)bit1 * Math.pow(16.0, 0.0))) != 0) {
                System.err.println("Oops, no character to conver to...");
            }
            convert.append(val + Character.toUpperCase(Integer.toHexString(bit4).charAt(0)) + Character.toUpperCase(Integer.toHexString(bit3).charAt(0)) + Character.toUpperCase(Integer.toHexString(bit2).charAt(0)) + Character.toUpperCase(Integer.toHexString(bit1).charAt(0)));
        }
        return convert.toString();
    }

    public static String hexEntityStringConvert(String theString) {
        int index = theString.indexOf("&#x");
        while (index != -1) {
            String value = theString.substring(index + 3, index + 7);
            char newChar = (char)Integer.valueOf(value, 16).intValue();
            String charString = String.valueOf(newChar);
            theString = theString.replaceAll("&#x" + value + ";", charString);
            theString = theString.replaceAll("&#x" + value, charString);
            index = theString.indexOf("&#x", index + 3);
        }
        return theString;
    }

    public static void toFrontHack(JFrame theParent, JFrame theFrame) {
        if (theFrame.getState() == 1) {
            theFrame.setState(0);
        } else {
            Point origPos = theFrame.getLocation();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            theFrame.setLocation(screenSize.width + theParent.getWidth(), screenSize.height + theParent.getHeight());
            theFrame.setState(1);
            theFrame.setState(0);
            theFrame.setLocation(origPos);
        }
        theParent.repaint();
        theFrame.repaint();
    }

    public static void centerFrame(Window theParent, Window theFrame) {
        if (theParent != null) {
            Dimension aSize = theFrame.getSize();
            int x = theParent.getX() + theParent.getWidth() / 2 - aSize.width / 2;
            int y = theParent.getY() + theParent.getHeight() / 2 - aSize.height / 2;
            theFrame.setLocation(x, y);
        } else {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension size = theFrame.getSize();
            screenSize.height /= 2;
            screenSize.width /= 2;
            size.height /= 2;
            size.width /= 2;
            int y = screenSize.height - size.height;
            int x = screenSize.width - size.width;
            theFrame.setLocation(x, y);
        }
    }

    public static boolean containsAny(Set theList, Set toSearch) {
        if (toSearch.isEmpty()) {
            return false;
        }
        for (Object obj : theList) {
            if (!toSearch.contains(obj)) continue;
            return true;
        }
        return false;
    }

    public static Set collectElements(Iterator theIter) {
        LinkedHashSet aSet = new LinkedHashSet();
        while (theIter.hasNext()) {
            aSet.add(theIter.next());
        }
        return aSet;
    }

    public static Image getTranslucentVersionOf(Image img) {
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        int[] pix = new int[w * h];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, w, h, pix, 0, w);
        try {
            pg.grabPixels();
        }
        catch (Exception e) {
            return img;
        }
        for (int i = pix.length - 1; i >= 0; --i) {
            pix[i] = 0x99000000 | pix[i] & 0xFFFFFF;
        }
        MemoryImageSource mis = new MemoryImageSource(w, h, pix, 0, w);
        return Toolkit.getDefaultToolkit().createImage(mis);
    }

    public static String replace(String host, String oldchar, String newchar) {
        int index = 0;
        while (host.indexOf(oldchar, index) != -1) {
            index = host.indexOf(oldchar, index);
            host = host.substring(0, index) + newchar + host.substring(index + oldchar.length(), host.length());
            index += newchar.length();
        }
        return host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(InputStream is) throws IOException {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }
}

