/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.utils;

import java.io.FileNotFoundException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eaglei.datatools.User;
import org.eaglei.datatools.etl.server.ETLRepositoryConfiguration;
import org.eaglei.datatools.etl.server.RepoService;
import org.eaglei.datatools.etl.utils.ETLSPARQLQueryUtil;
import org.eaglei.datatools.jena.RepositorySecurityProvider;
import org.eaglei.model.jena.SPARQLQueryUtil;
import org.eaglei.security.Session;

public class BulkOperation {
    private static Logger logger = Logger.getLogger(BulkOperation.class);
    private RepoService rdftorepo;
    private Session session;

    public BulkOperation(String repo) throws Exception {
        try {
            this.rdftorepo = RepoService.getInstance(repo, null);
        }
        catch (FileNotFoundException fe) {
            logger.error((Object)"Repository information file not found");
            logger.error((Object)fe);
            throw fe;
        }
        RepositorySecurityProvider provider = RepositorySecurityProvider.getInstance();
        Map<String, String> credentialMap = ETLRepositoryConfiguration.getCredentialsForRepo(repo);
        try {
            User strAry = provider.login(credentialMap.get("user"), credentialMap.get("password"));
            if (strAry == null) {
                logger.error((Object)"Could not authenticate please check username,password and Repository URL...Exiting System");
                System.exit(2);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception thrown in constructor");
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public String[] getResourcesOfFile(String fileName) {
        try {
            logger.info((Object)("making delete query for filename" + fileName));
            String query = SPARQLQueryUtil.getInstance().getResourcesETLedFromFileQuery(fileName);
            logger.info((Object)("querying the repository for resources ETLed from " + fileName));
            String resources = this.rdftorepo.getRepositoryProvider().query(this.rdftorepo.getSession(), query);
            String[] instanceURIAry = ETLSPARQLQueryUtil.getInstanceURI(resources);
            logger.info((Object)("Query returned " + instanceURIAry.length + " resources"));
            return instanceURIAry;
        }
        catch (Exception e) {
            logger.error((Object)"exception thrown in getResourcesOfFile()");
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    public RepoService getRdftorepo() {
        return this.rdftorepo;
    }
}

