/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.utils;

import java.util.Arrays;
import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.RepoService;
import org.eaglei.datatools.etl.server.loader.Loader;
import org.eaglei.datatools.etl.utils.BulkOperation;
import org.eaglei.datatools.etl.utils.DeETL;
import org.eaglei.model.EIURI;

public class BulkWorkFlow
extends BulkOperation {
    private static Logger logger = Logger.getLogger(DeETL.class);
    private static String fileName;
    private static String repo;
    private static Loader.Promote promoteParameter;
    public static RepoService rdftorepo;

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length - 1; ++i) {
            if (args[i].equals("-f")) {
                fileName = args[++i];
                continue;
            }
            if (args[i].equals("-r")) {
                repo = args[++i];
                continue;
            }
            if (!args[i].equals("-p")) continue;
            promoteParameter = Loader.Promote.getPromote(args[++i]);
        }
        BulkWorkFlow bulkworkflow = new BulkWorkFlow(repo);
        bulkworkflow.promote(promoteParameter);
    }

    public BulkWorkFlow(String repo) throws Exception {
        super(repo);
    }

    public void promote(Loader.Promote promote) {
        String[] instanceURIAry = this.getResourcesOfFile(fileName);
        int i = 0;
        for (String instanceURI : instanceURIAry) {
            try {
                this.getRdftorepo().getRepositoryProvider().claim(this.getRdftorepo().getSession(), Arrays.asList(EIURI.create((String)instanceURI)));
                this.getRdftorepo().workFlowTansistion(Arrays.asList(EIURI.create((String)instanceURI)), promote);
                if (++i % 50 != 0) continue;
                System.gc();
            }
            catch (Exception e) {
                logger.error((Object)("There is Error in deleting this resource" + instanceURI));
            }
        }
        if (i == 0) {
            logger.info((Object)"There are no resources with this file to delete");
        }
    }
}

