/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.utils;

import java.util.Arrays;
import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.utils.BulkOperation;
import org.eaglei.model.EIURI;

public class DeETL
extends BulkOperation {
    private static Logger logger = Logger.getLogger(DeETL.class);
    private static String fileName;
    private static String repo;

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length - 1; ++i) {
            if (args[i].equals("-f")) {
                fileName = args[++i];
                continue;
            }
            if (!args[i].equals("-r")) continue;
            repo = args[++i];
        }
        DeETL deetl = new DeETL(repo);
        deetl.deleteInstanceETLedFromFile(fileName);
        logger.info((Object)"delete complete");
    }

    public DeETL(String repo) throws Exception {
        super(repo);
    }

    public int deleteInstanceETLedFromFile(String fileName) throws Exception {
        String[] instanceURIAry = this.getResourcesOfFile(fileName);
        int i = 0;
        for (String instaceURI : instanceURIAry) {
            try {
                this.getRdftorepo().getRepositoryProvider().claim(this.getRdftorepo().getSession(), Arrays.asList(EIURI.create((String)instaceURI)));
                logger.info((Object)("deleting " + instaceURI));
                this.getRdftorepo().getRepositoryProvider().deleteInstance(this.getRdftorepo().getSession(), EIURI.create((String)instaceURI));
                if (++i % 50 != 0) continue;
                System.gc();
            }
            catch (Exception e) {
                logger.error((Object)("There is Error in deleting this resource" + instaceURI));
            }
        }
        if (i == 0) {
            logger.info((Object)"There are no resources with this file to delete");
        }
        return i;
    }
}

