package org.eaglei.datatools.etl.server;

import java.io.File;

import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.eaglei.datatools.etl.server.exceptions.BadInputException;
import org.eaglei.datatools.etl.server.loader.Loader;

public final class ETLInputs
{
	
	private final  String logFile;
	private final  String outputDirectoryFile;
	private final String errorFileDirecotry;
	
	private final  String repoConfigFileLocation;
	private final String mapsParentDirectoryPath;
	private final String excelFilesDirectoryPath;
	
	private  final Loader.Promote promoteParameter;
	private static org.apache.log4j.Logger logger = Logger.getLogger( ETLInputs.class );
	
	
	public ETLInputs(String excelFilesDirectoryPath,String mapsParentDirectoryPath,
			         String repoConfigFileLocation,Loader.Promote promoteParameter,String logFile,
			         String outputDirectoryFile,String errorFileDirecotry) throws BadInputException {
		
		this.repoConfigFileLocation=repoConfigFileLocation;
		this.mapsParentDirectoryPath=mapsParentDirectoryPath;
		this.excelFilesDirectoryPath=excelFilesDirectoryPath;
		this.logFile=logFile;
		this.outputDirectoryFile=outputDirectoryFile;
		this.errorFileDirecotry=errorFileDirecotry;
		this.promoteParameter=promoteParameter;
		checkInputs();
		
		
	}


	public String getLogFile() {
		return logFile;
	}


	public String getOutputDirectoryFile() {
		return outputDirectoryFile;
	}


	public String getErrorFileDirecotry() {
		return errorFileDirecotry;
	}


	public String getRepoConfigFileLocation() {
		return repoConfigFileLocation;
	}


	public String getMapsParentDirectoryPath() {
		return mapsParentDirectoryPath;
	}


	public String getExcelFilesDirectoryPath() {
		return excelFilesDirectoryPath;
	}


	public Loader.Promote getPromoteParameter() {
		return promoteParameter;
	}
	
	private  void checkInputs() throws BadInputException{
		if ( excelFilesDirectoryPath == null ) {
			throw new BadInputException("Excel Files location is not provided ,this input is mandatory" );
		}
		if ( repoConfigFileLocation == null ) {
			
			throw new BadInputException("Repository is not provided ,this input is mandatory" );
		}
		if ( mapsParentDirectoryPath == null ) {
			throw new BadInputException("Maps location are not provided ,this input is mandatory");
		}
		File repoConfigFile = new File(repoConfigFileLocation);
		if(!repoConfigFile.isFile())
		{
			throw new BadInputException("the supplied repo config file input is not a file");
		}
		
		File excelDirecotryPath =new File(excelFilesDirectoryPath);
		if(!excelDirecotryPath.isDirectory())
		{
			throw new BadInputException("the supplied excel directory path is not directory");
		}
		
		File mapsParentPath = new File(mapsParentDirectoryPath);
		if(!mapsParentPath.isDirectory())
		{
			throw new BadInputException("the supplied maps Parent directory path is not directory");
		}
	
	}

	
		
	
}

