/**
 * 
 */
package org.eaglei.datatools.etl.server.extractor;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.exceptions.NotADirectoryException;



/**
 * @author Sravan Cheriyala
 * 
 */
public class FileIterator implements Iterator<File> {
	private String directoryPath;
	private File directory;
	private List<String> childFiles;
	private List<FileIterator> subDirectoriesIteratorsList;
	int index = 0;
	int subDirecotryIndex = 0;
	private static org.apache.log4j.Logger logger = Logger.getLogger( FileIterator.class );

	public FileIterator(String directoryPath) throws NotADirectoryException {
		this.directoryPath = directoryPath;
		childFiles = new ArrayList<String>();
		subDirectoriesIteratorsList = new ArrayList<FileIterator>();
		directory = new File( directoryPath );
		if ( !directory.isDirectory() ) {
			logger.error( directoryPath + " is not a directory...exiting" );
			throw new NotADirectoryException( "Expecting directory but the supplied is a path of file" );
		}
		childFiles = Arrays.asList( directory.list() );
	}

	@Override
	public boolean hasNext() {

		if ( ( index+1 > childFiles.size() && subDirectoriesIteratorsList.size() == 0 ) ) {
			return false;
		} else if ( subDirectoriesIteratorsList.size() != 0 && subDirecotryIndex == subDirectoriesIteratorsList.size()-1  && !subDirectoriesIteratorsList.get( subDirecotryIndex ).hasNext() ) {
			return false;
		} else {
			return true;
		}
	}

	@Override
	public File next() {
		try {
			return getNextFile();
		} catch (FileNotFoundException ex) {
			logger.error( "FileNotFoundExeption in getting next file, continuing onto getting other files" );
			return next();
		} catch (NotADirectoryException ex) {
			logger.error( "NotADirectory in getting next file, continuing onto getting other files" );
			return next();
		}
	}

	@Override
	public void remove() {

	}

	private File getNextFile() throws FileNotFoundException, NotADirectoryException {
		if ( index <= childFiles.size() - 1 ) {
			String childFileString = childFiles.get( index++ );
			String fullFilePath = directoryPath + "/" + childFileString;
			File childFile = new File( fullFilePath );
			if ( childFile.isDirectory() ) {
				subDirectoriesIteratorsList.add( new FileIterator( fullFilePath ) );
				return getNextFile();
			} else {
				return childFile;
			}
		}
		else {
			return getNextSubDirectoriesFile();
		}
	}

	private File getNextSubDirectoriesFile() {
		File lastSubDirecotry;
		if(subDirectoriesIteratorsList.size()==1)
		{
			lastSubDirecotry = subDirectoriesIteratorsList.get( 0 ).next();
		}
		else if ( subDirecotryIndex == subDirectoriesIteratorsList.size()-1 ) {
			lastSubDirecotry = subDirectoriesIteratorsList.get( subDirecotryIndex ).next();
		}
		 else if ( subDirectoriesIteratorsList.get( subDirecotryIndex ).hasNext() ) {
			return subDirectoriesIteratorsList.get( subDirecotryIndex ).next();
		}  else {
			subDirecotryIndex++;
			return getNextSubDirectoriesFile();
		}
		return lastSubDirecotry;
	}
}
