/**
 * 
 */
package org.eaglei.datatools.etl.server.extractor.parsers;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;

import org.apache.commons.configuration.ConfigurationException;
import org.eaglei.datatools.etl.server.exceptions.ExtractorException;

/**
 * 
 * Eagle-i Parser for ETL ,the implemented class of the EIFileParser should typically have the Constructor with 'file' argument.
 * 
 * @author Sravan Cheriyala
 * 
 */
public abstract class EIFileParser<I> {
	/**
	 * 
	 * parses the file passed in the constructor using the template Configuration file .
	 * 
	 * @param templateConfigFile
	 * @return <I>
	 * @throws ConfigurationException
	 * @throws IOException
	 * @throws ParseException
	 * @throws ExtractorException
	 */
	public abstract I parse(File templateConfigFile) throws ConfigurationException, IOException, ParseException, ExtractorException;

}
