/**
 * 
 */
package org.eaglei.datatools.etl.server.extractor.parsers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

/**
 * @author "Sravan Cheriyala"
 * Started Feb 25, 2011
 */
public abstract  class MapFileConfiguration {
	
	public static String[] getOrderofMapFiles(String mapDirectoryPath) throws ConfigurationException {
		PropertiesConfiguration config = new PropertiesConfiguration( mapDirectoryPath + "/mapfileinfo.properties" );
		String order = config.getString( "process.order" );
		String[] stringArrayToReturn = order.split( "#" );
		return stringArrayToReturn;
	}
	
	public static Map<String, String> getMapInfo(String mapPath) throws ConfigurationException {
		Map<String, String> rowInfoMap = new HashMap<String, String>();
		PropertiesConfiguration config = new PropertiesConfiguration( mapPath );
		Iterator<String> iter = config.getKeys();
		while ( iter.hasNext() ) {
			String key = iter.next();
			rowInfoMap.put( key, config.getString( key ) );
		}
		return rowInfoMap;
	}

}
