/**
 * 
 */
package org.eaglei.datatools.etl.server.extractor.parsers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.LoggerFactory;

/**
 * @author Sravan Cheriyala
 * 
 */
public class RowIterator {

	private int indexVariable = 0;
	private Data data;
	private final int COLUMN_NAME = 0;
	private final int COLUMN_VALUE = 1;

	public RowIterator(Data data) {
		this.data = data;
		this.indexVariable = 0;
	}

	public boolean hasNext() {

		if ( indexVariable <= data.getRowCount()-1 ) {
			indexVariable = indexVariable + 1;
			return true;
		} else {
			return false;
		}
	}

	public Map<String, String> nextRow() {
		Map<String, String> columnMap = new HashMap<String, String>();
		int row = indexVariable-1;
		int columnCount = data.getColumnCount();
		for (int i = 0; i <= columnCount - 1; i++) {
			String[] columnData = (String[])data.getValueAt( row, i );
			if ( columnData != null ) {
				columnMap.put( columnData[COLUMN_NAME].toUpperCase(), columnData[COLUMN_VALUE] );
			}
		}

		return columnMap;
	}

}
