package org.eaglei.datatools.etl.server.transformer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.ETLEntryPoint;
import org.eaglei.datatools.etl.server.RepoService;
import org.eaglei.datatools.etl.utils.ETLUtils;
import org.eaglei.datatools.model.AnnotationFormModel;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;

public class EmbeddedExpression extends Expression<Statement[]> {

	private static Logger logger = Logger.getLogger( EmbeddedExpression.class );

	public static final String EMBEDDED_CLASS_EXPRESSION_MATCHER = "Ex:emb";

	private String embeddedExpression;
	private Map<String,String> columnMap;
	private Statement mapStatement;
	private Model mapModel;
	private AnnotationFormModel anntModel;
	private RepoService repoService;

	//FIXME too many arguments
	public EmbeddedExpression(String embeddedExpression, Map<String,String> columnMap, Statement mapStatement, Model mapModel, AnnotationFormModel anntModel,RepoService repoService) {
		this.embeddedExpression = embeddedExpression;
		this.columnMap = columnMap;
		this.mapStatement = mapStatement;
		this.mapModel = mapModel;
		this.anntModel = anntModel;
		this.repoService=repoService;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.etl.server.MapInterpreter.Expression#interpret (org.eaglei.datatools.etl.server.ExcelAbstractions.ExcelTabData, int)
	 */
	@Override
	public Statement[] interpret() {
		try {

			Model subNodeModel = ETLUtils.getsubModelByExpression( embeddedExpression, mapModel );
			/* if there is semicolon on excel data then process that. */
			SemiColonExpresson semiColonExpression = new SemiColonExpresson( subNodeModel,columnMap );
			Model[] modelAfterSemiColonInterpretation = semiColonExpression.interpret();
			ArrayList<Statement> statementList = new ArrayList<Statement>();

			/*
			 * if there is really a semicolon then above semiColonExpression returns the Model array ,each Model is for each string separated by semicolon
			 */
			for (Model model : modelAfterSemiColonInterpretation) {
				MapInterpreter subNodeMapEvaluator = new MapInterpreter( mapModel, model, columnMap, embeddedExpression, mapStatement, anntModel,repoService );
				Statement[] statementAry = subNodeMapEvaluator.interpret();
				if ( statementAry == null || statementAry.length <= 1 || !ETLUtils.isLabelPresentInMap( statementAry ) ) {
					continue;
				}
				/* replace Secondary instance Expression with new instance URI */
				Resource subject = ETLEntryPoint.getInstance().getRepoService().getNewResourceFromRepository( subNodeModel );
				List<Statement> returnedstatementList = ETLUtils.replaceExpressionWithURI( statementAry, subject, embeddedExpression );
				Statement statementOfMainInstance = subNodeModel.createStatement( mapStatement.getSubject(), mapStatement.getPredicate(), subject );
				returnedstatementList.add( statementOfMainInstance );
				statementList.addAll( returnedstatementList );

			}

			return statementList.toArray( new Statement[statementList.size()] );
		}// FIXME: temporarly throwing Runtime exception until we find better solution on how to handle exceptions
		catch (IOException ioe) {
			logger.error( "IO Exception Occured in interpret method of EmbeddedClassExpression class" );
			throw new RuntimeException( ioe );
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.etl.server.Expression#getExpressionString()
	 */
	@Override
	public String getExpressionString() {

		return EMBEDDED_CLASS_EXPRESSION_MATCHER;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.etl.server.Expression#getExpressionStatement()
	 */
	@Override
	public Statement getExpressionStatement() {
		// TODO Auto-generated method stub
		return mapStatement;
	}

}
