/**
 * eagle-i Project
 * Harvard University
 * Feb 15, 2010
 */
package org.eaglei.datatools.interim.cores;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author dbw
 * @deprecated -- to replace with apache iocommons utilities
 */
public class OldFileUtils {
	private static final Log logger = LogFactory.getLog(OldFileUtils.class);
	
    /**
     * return a List of all files in input directory (recursively looking into subdirectories)
     *
     * @param inputDir a valid directory, which can be read.
     */
     public static List<File> getAllFiles(File inputDir) throws FileNotFoundException {
       validateDirectory(inputDir, false);
       List<File> files =  new ArrayList<File>();
       List<File> filesAndDirs = Arrays.asList(inputDir.listFiles());
       for(File file : filesAndDirs) {
         files.add(file); 
         if (!file.isFile() ) {
           //must be a directory
           //recurse
           List<File> deeperList = getAllFiles(file);
           files.addAll(deeperList);
         }
       }
       return files;
     }

     public static void validateDirectory(String dirString, boolean create) throws FileNotFoundException {
    	 final File dir = new File(dirString);
    	 validateDirectory(dir, create);
     }
     
     /**
     * Directory is valid if it exists, does not represent a file, and can be read.
     *
     * @param dir
     * @param create - if the directory doesn't exist, create it
     * @throws FileNotFoundException
     */
     public static void validateDirectory(File dir, boolean create) throws FileNotFoundException {
       if (dir == null) {
         throw new IllegalArgumentException("Directory should not be null.");
       }
       if (!dir.exists()) {
    	   if(create) {
    		   if(!dir.mkdir())
    			   throw new IllegalArgumentException("Failed to create directory: " + dir);
    		   else
    			   if(logger.isDebugEnabled())logger.debug("Creating directory: " + dir);
    	   } else
    		   throw new FileNotFoundException("Directory does not exist: " + dir);
       }
       if (!dir.isDirectory()) {
         throw new IllegalArgumentException("Is not a directory: " + dir);
       }
       if (!dir.canRead()) {
         throw new IllegalArgumentException("Directory cannot be read: " + dir);
       }
     }

}
