/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class BROOntologyReasoner {
    OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, null);

    public BROOntologyReasoner() throws FileNotFoundException {
        FileInputStream mapStream = new FileInputStream(BROOntologyReasoner.class.getClassLoader().getResource("BRO.owl").getFile());
        Model mapModel = ModelFactory.createDefaultModel();
        mapModel.read((InputStream)mapStream, "RDF/XML");
        mapModel.removeNsPrefix("");
        this.ontModel.add(mapModel);
    }

    public boolean isSubClass(String ancestorURI, String descendentURI) {
        OntClass descendentClass;
        OntClass ancestorOntClass = this.getOntologyClass(ancestorURI);
        if (!ancestorOntClass.hasSubClass((Resource)(descendentClass = this.getOntologyClass(descendentURI)))) {
            ExtendedIterator ontIterator = ancestorOntClass.listSubClasses();
            while (ontIterator.hasNext()) {
                OntClass subOntClass = (OntClass)ontIterator.next();
                if (!this.isSubClass(subOntClass.getURI(), descendentURI)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private OntClass getOntologyClass(String strURI) {
        return this.ontModel.getOntClass(strURI);
    }

    public String getEagleIResource(String broResource) {
        if (this.isSubClass("http://bioontology.org/ontologies/BiomedicalResourceOntology.owl#Funding_Resource", broResource)) {
            return "http://purl.obolibrary.org/obo/OBI_0000245";
        }
        if (this.isSubClass("http://bioontology.org/ontologies/BiomedicalResourceOntology.owl#Information_Resource", broResource)) {
            return "http://purl.obolibrary.org/obo/ERO_0000071";
        }
        if (this.isSubClass("http://bioontology.org/ontologies/BiomedicalResourceOntology.owl#Material_Resource", broResource) && !this.isSubClass("http://bioontology.org/ontologies/BiomedicalResourceOntology.owl#Facility_Core", broResource)) {
            return "http://purl.obolibrary.org/obo/ERO_0000004";
        }
        if (this.isSubClass("http://bioontology.org/ontologies/BiomedicalResourceOntology.owl#Facility_Core", broResource)) {
            return "http://purl.obolibrary.org/obo/ERO_0000002";
        }
        if (this.isSubClass("http://bioontology.org/ontologies/BiomedicalResourceOntology.owl#People_Resource", broResource) || this.isSubClass("http://bioontology.org/ontologies/BiomedicalResourceOntology.owl#Service_Resource", broResource) || this.isSubClass("http://bioontology.org/ontologies/BiomedicalResourceOntology.owl#Training_Resource", broResource) && !this.isSubClass("http://bioontology.org/ontologies/BiomedicalResourceOntology.owl#Facility_Core", broResource)) {
            return "http://purl.obolibrary.org/obo/ERO_0000005";
        }
        if (this.isSubClass("http://bioontology.org/ontologies/BiomedicalResourceOntology.owl#Software", broResource)) {
            return "http://purl.obolibrary.org/obo/ERO_0000071";
        }
        if (this.isSubClass("http://bioontology.org/ontologies/BiomedicalResourceOntology.owl#Deprecated_Resource", broResource)) {
            return "http://purl.obolibrary.org/obo/IAO_0000310";
        }
        return "http://purl.obolibrary.org/obo/ERO_0000071";
    }
}

