/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server;

import com.hp.hpl.jena.rdf.model.Statement;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.ETLInputs;
import org.eaglei.datatools.etl.server.FileStatistics;
import org.eaglei.datatools.etl.server.LoggerFactory;
import org.eaglei.datatools.etl.server.RepoService;
import org.eaglei.datatools.etl.server.exceptions.BadInputException;
import org.eaglei.datatools.etl.server.exceptions.ExceptionWhileMakingRepoSerivce;
import org.eaglei.datatools.etl.server.exceptions.ExtractorException;
import org.eaglei.datatools.etl.server.exceptions.LoaderException;
import org.eaglei.datatools.etl.server.exceptions.NotADirectoryException;
import org.eaglei.datatools.etl.server.exceptions.UnsupportedFileException;
import org.eaglei.datatools.etl.server.extractor.Extractor;
import org.eaglei.datatools.etl.server.extractor.ExtractorFactory;
import org.eaglei.datatools.etl.server.extractor.FileIterator;
import org.eaglei.datatools.etl.server.extractor.parsers.Data;
import org.eaglei.datatools.etl.server.extractor.parsers.MapFileConfiguration;
import org.eaglei.datatools.etl.server.extractor.parsers.RowIterator;
import org.eaglei.datatools.etl.server.loader.Loader;
import org.eaglei.datatools.etl.server.loader.LoaderImpl;
import org.eaglei.datatools.etl.server.transformer.Transformer;
import org.eaglei.datatools.etl.server.transformer.TransformerImpl;
import org.eaglei.datatools.model.AnnotationFormModel;
import org.eaglei.model.jena.JenaEIInstanceFactory;
import org.eaglei.services.repository.SecurityProvider;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.xml.sax.SAXException;

public class ETLEntryPoint {
    private static Logger errLogger;
    private static Logger logger;
    private static ETLInputs etlInputs;
    private static ETLEntryPoint entryPoint;
    private AnnotationFormModel anntModel;
    private JenaEIInstanceFactory jenaInstanceFactory;
    private SecurityProvider generalSecurityProvider;
    private RepoService repoService;
    private String currentlyProcessingFile;
    private List<FileStatistics> fileStatisticsList;
    private Loader loader;
    private Transformer transformer;

    public static void main(String[] args) {
        try {
            if (args.length > 0) {
                String logFile = "";
                String outputDirectoryFile = "";
                String errorFileDirecotry = "";
                String repoConfigFileLocation = "";
                String mapsParentDirectoryPath = "";
                String excelFilesDirectoryPath = "";
                Loader.Promote promoteParameter = Loader.Promote.DRAFT;
                for (int i = 0; i < args.length - 1; ++i) {
                    if (args[i].equals("-d")) {
                        excelFilesDirectoryPath = args[++i];
                        continue;
                    }
                    if (args[i].equals("-o")) {
                        outputDirectoryFile = args[++i];
                        continue;
                    }
                    if (args[i].equals("-r")) {
                        repoConfigFileLocation = args[++i];
                        continue;
                    }
                    if (args[i].equals("-l")) {
                        logFile = args[++i];
                        continue;
                    }
                    if (args[i].equals("-m")) {
                        mapsParentDirectoryPath = args[++i];
                        continue;
                    }
                    if (args[i].equals("-p")) {
                        promoteParameter = Loader.Promote.getPromote(args[++i]);
                        continue;
                    }
                    if (!args[i].equals("-e")) continue;
                    errorFileDirecotry = args[++i];
                }
                etlInputs = new ETLInputs(excelFilesDirectoryPath, mapsParentDirectoryPath, repoConfigFileLocation, promoteParameter, logFile, outputDirectoryFile, errorFileDirecotry);
                ETLEntryPoint.setEtlInputs(etlInputs);
                entryPoint = ETLEntryPoint.getInstance();
                entryPoint.doETL(etlInputs.getExcelFilesDirectoryPath());
                logger.info((Object)"finished ETL.");
                entryPoint.printStatistics();
                logger.info((Object)"---------------------done-------------------------");
            }
        }
        catch (IOException e) {
            logger.error((Object)"IO error while ETLing ");
            logger.error((Object)e.getMessage());
            System.exit(2);
        }
        catch (BadInputException bie) {
            logger.error((Object)"Exiting System");
            logger.error((Object)bie.getMessage());
            System.exit(2);
        }
    }

    public static ETLEntryPoint getInstance() {
        if (entryPoint == null) {
            entryPoint = new ETLEntryPoint();
            return entryPoint;
        }
        return entryPoint;
    }

    private ETLEntryPoint() {
        try {
            ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{"datatools-model-config.xml"});
            this.anntModel = (AnnotationFormModel)context.getBean(AnnotationFormModel.class);
            this.jenaInstanceFactory = (JenaEIInstanceFactory)context.getBean(JenaEIInstanceFactory.class);
            this.generalSecurityProvider = (SecurityProvider)context.getBean(SecurityProvider.class);
            this.fileStatisticsList = new ArrayList<FileStatistics>();
            this.repoService = this.makeRepoService(etlInputs.getRepoConfigFileLocation());
            this.loader = new LoaderImpl(this.repoService, this.jenaInstanceFactory, this.anntModel);
            this.transformer = new TransformerImpl(this.anntModel, this.repoService);
            LoggerFactory.intializeLoggers(etlInputs.getErrorFileDirecotry(), etlInputs.getOutputDirectoryFile());
            errLogger = LoggerFactory.errorFileLogger;
        }
        catch (ExceptionWhileMakingRepoSerivce e) {
            logger.error((Object)"Cannot make repository serive class");
            logger.error((Object)e.getMessage());
            System.exit(2);
        }
    }

    public void doETL(String direcotryPath) throws NotADirectoryException {
        FileIterator fileIter = new FileIterator(direcotryPath);
        while (fileIter.hasNext()) {
            File file = fileIter.next();
            this.currentlyProcessingFile = file.getName();
            FileStatistics statistics = new FileStatistics(file.getName());
            LoggerFactory.appendErrorFileToLogger(etlInputs.getErrorFileDirecotry() + "/" + file.getName().replaceAll("\\..*$", ".txt").replaceAll(".xls", ".txt"));
            LoggerFactory.appendOutputFileToLogger(etlInputs.getOutputDirectoryFile() + "/" + file.getName().replaceAll("\\..*$", ".txt").replaceAll(".xls", ".txt"));
            try {
                Extractor extractor = this.getExtracter(file);
                this.doTransform(extractor, statistics, etlInputs.getMapsParentDirectoryPath());
            }
            catch (UnsupportedFileException e) {
                this.logerror(e, "this file format is currently unsupported " + file.getName());
            }
            catch (ExtractorException e) {
                this.logerror(e, "error while extracting file " + file.getName());
            }
            catch (ParserConfigurationException e) {
                this.logerror(e, "parse configuration error while parsing file" + file.getName());
            }
            catch (SAXException e) {
                this.logerror(e, "Sax parserException while parsing xml file " + file.getName());
            }
            catch (ConfigurationException e) {
                this.logerror((Exception)((Object)e), "error reading configuration information file for this file " + file.getName());
            }
            catch (ParseException e) {
                this.logerror(e, "Parsing error while  reading  file " + file.getName());
            }
            catch (IOException e) {
                this.logerror(e, "IO error reading  file " + file.getName());
            }
        }
    }

    private void logerror(Exception e, String msg) {
        errLogger.error((Object)msg);
        errLogger.error((Object)e.getMessage());
        errLogger.error((Object)"continuing onto next file");
    }

    public Extractor getExtracter(File excelFile) throws ParseException, ParserConfigurationException, SAXException, IOException, UnsupportedFileException {
        Extractor extractor = ExtractorFactory.getExtractor(excelFile);
        return extractor;
    }

    public void doTransform(Extractor extractor, FileStatistics statistics, String mapsParentDirectoryPath) throws IOException, ConfigurationException, ParseException, ExtractorException {
        String[] tabOrderToProcess;
        String formVersion = extractor.getFormVersion();
        File mapDirectory = extractor.getMapDirectory(formVersion, new File(mapsParentDirectoryPath));
        Map<String, File> mapFiles = extractor.getMapFiles(mapDirectory);
        Map<String, Data> mapOfData = extractor.getData(mapDirectory);
        for (String tabName : tabOrderToProcess = MapFileConfiguration.getOrderofMapFiles(mapDirectory.getPath())) {
            Data data = mapOfData.get(tabName.toUpperCase());
            if (data == null) continue;
            RowIterator rowIterator = new RowIterator(data);
            File mapFile = mapFiles.get(tabName.toUpperCase());
            int sucessCount = 0;
            int failureCount = 0;
            int rowCount = 0;
            while (rowIterator.hasNext()) {
                try {
                    ++rowCount;
                    Map<String, String> rowMap = rowIterator.nextRow();
                    Statement[] statements = this.transformer.transformToRDF(rowMap, mapFile);
                    this.doLoading(statements);
                    statistics.setSucessCount(sucessCount++);
                }
                catch (Exception e) {
                    errLogger.error((Object)("error when transforming and loading the row " + rowCount));
                    errLogger.error((Object)Arrays.toString(e.getStackTrace()));
                    errLogger.error((Object)e.getCause());
                    errLogger.error((Object)e.getMessage());
                    statistics.setFailureCount(failureCount++);
                }
            }
        }
    }

    public void doLoading(Statement[] statements) throws LoaderException {
        this.loader.load(statements, this.getCurrentlyProcessingFile(), etlInputs.getPromoteParameter());
    }

    private void printStatistics() {
        logger.info((Object)"the ETL statistics are as follows");
        logger.info((Object)"File Name          SuccessRows          FailureRows");
        for (FileStatistics stats : this.fileStatisticsList) {
            logger.info((Object)(stats.getFileName() + "          " + stats.getSucessCount() + "          " + stats.getFailureCount()));
        }
    }

    private RepoService makeRepoService(String repoConfigFileLocation) throws ExceptionWhileMakingRepoSerivce {
        try {
            RepoService repoService = RepoService.getInstance(repoConfigFileLocation, this.jenaInstanceFactory, this.generalSecurityProvider);
            return repoService;
        }
        catch (FileNotFoundException fe) {
            logger.error((Object)"Repository information file not found");
            logger.error((Object)fe);
            throw new ExceptionWhileMakingRepoSerivce(fe);
        }
        catch (Exception e) {
            logger.error((Object)"Exception while making repoSerivce");
            logger.error((Object)e);
            throw new ExceptionWhileMakingRepoSerivce(e);
        }
    }

    public RepoService getRepoService() {
        return this.repoService;
    }

    public static ETLInputs getEtlInputs() {
        return etlInputs;
    }

    public static ETLInputs setEtlInputs(ETLInputs etlInputs) {
        ETLEntryPoint.etlInputs = etlInputs;
        return ETLEntryPoint.etlInputs;
    }

    public AnnotationFormModel getAnntModel() {
        return this.anntModel;
    }

    public JenaEIInstanceFactory getInstanceFactory() {
        return this.jenaInstanceFactory;
    }

    public String getCurrentlyProcessingFile() {
        return this.currentlyProcessingFile;
    }

    static {
        logger = Logger.getLogger(ETLEntryPoint.class);
    }
}

