/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server;

import java.io.File;
import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.exceptions.BadInputException;
import org.eaglei.datatools.etl.server.loader.Loader;

public final class ETLInputs {
    private final String logFile;
    private final String outputDirectoryFile;
    private final String errorFileDirecotry;
    private final String repoConfigFileLocation;
    private final String mapsParentDirectoryPath;
    private final String excelFilesDirectoryPath;
    private final Loader.Promote promoteParameter;
    private static Logger logger = Logger.getLogger(ETLInputs.class);

    public ETLInputs(String excelFilesDirectoryPath, String mapsParentDirectoryPath, String repoConfigFileLocation, Loader.Promote promoteParameter, String logFile, String outputDirectoryFile, String errorFileDirecotry) throws BadInputException {
        this.repoConfigFileLocation = repoConfigFileLocation;
        this.mapsParentDirectoryPath = mapsParentDirectoryPath;
        this.excelFilesDirectoryPath = excelFilesDirectoryPath;
        this.logFile = logFile;
        this.outputDirectoryFile = outputDirectoryFile;
        this.errorFileDirecotry = errorFileDirecotry;
        this.promoteParameter = promoteParameter;
        this.checkInputs();
    }

    public String getLogFile() {
        return this.logFile;
    }

    public String getOutputDirectoryFile() {
        return this.outputDirectoryFile;
    }

    public String getErrorFileDirecotry() {
        return this.errorFileDirecotry;
    }

    public String getRepoConfigFileLocation() {
        return this.repoConfigFileLocation;
    }

    public String getMapsParentDirectoryPath() {
        return this.mapsParentDirectoryPath;
    }

    public String getExcelFilesDirectoryPath() {
        return this.excelFilesDirectoryPath;
    }

    public Loader.Promote getPromoteParameter() {
        return this.promoteParameter;
    }

    private void checkInputs() throws BadInputException {
        if (this.excelFilesDirectoryPath == null) {
            throw new BadInputException("Excel Files location is not provided ,this input is mandatory");
        }
        if (this.repoConfigFileLocation == null) {
            throw new BadInputException("Repository is not provided ,this input is mandatory");
        }
        if (this.mapsParentDirectoryPath == null) {
            throw new BadInputException("Maps location are not provided ,this input is mandatory");
        }
        File repoConfigFile = new File(this.repoConfigFileLocation);
        if (!repoConfigFile.isFile()) {
            throw new BadInputException("the supplied repo config file input is not a file");
        }
        File excelDirecotryPath = new File(this.excelFilesDirectoryPath);
        if (!excelDirecotryPath.isDirectory()) {
            throw new BadInputException("the supplied excel directory path is not directory");
        }
        File mapsParentPath = new File(this.mapsParentDirectoryPath);
        if (!mapsParentPath.isDirectory()) {
            throw new BadInputException("the supplied maps Parent directory path is not directory");
        }
    }
}

