/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class ETLRepositoryConfiguration {
    public static Map<String, String> getdcCreatorFromRepoFile(String repoPath) throws ConfigurationException {
        String[] dccreatorAry;
        HashMap<String, String> dcCreatorMap = new HashMap<String, String>();
        PropertiesConfiguration config = new PropertiesConfiguration(repoPath);
        config.setDelimiterParsingDisabled(true);
        for (String dccreator : dccreatorAry = config.getStringArray("datatools.repository.dccreator")) {
            String[] splitAry = dccreator.split("#");
            dcCreatorMap.put(splitAry[0].replace(";", ","), splitAry[1]);
        }
        return dcCreatorMap;
    }

    public static Map<String, String> getCredentialsForRepo(String repoPath) throws ConfigurationException {
        HashMap<String, String> rowInfoMap = new HashMap<String, String>();
        PropertiesConfiguration config = new PropertiesConfiguration(repoPath);
        String user = config.getString("datatools.repository.user");
        String password = config.getString("datatools.repository.password");
        rowInfoMap.put("user", user);
        rowInfoMap.put("password", password);
        return rowInfoMap;
    }
}

