/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server;

import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class LoggerFactory {
    private static Logger logger = Logger.getLogger(LoggerFactory.class);
    private static LoggerFactory loggerFactory;
    public static Logger errorFileLogger;
    public static Logger outputFileLogger;

    public static void intializeLoggers(String errorFile, String outputFile) {
        if (loggerFactory == null) {
            loggerFactory = new LoggerFactory();
        }
    }

    private LoggerFactory() {
    }

    public static void appendErrorFileToLogger(String errorFile) {
        try {
            errorFileLogger.removeAllAppenders();
            FileAppender errorFileAppender = new FileAppender((Layout)new PatternLayout(), errorFile);
            errorFileLogger.addAppender((Appender)errorFileAppender);
            errorFileLogger.setLevel(Level.DEBUG);
        }
        catch (IOException ioe) {
            logger.info((Object)"error directory not supplied");
        }
        catch (ExceptionInInitializerError eii) {
            logger.info((Object)"initialization exception in creting error logger");
        }
    }

    public static void appendOutputFileToLogger(String outputFile) {
        try {
            outputFileLogger.removeAllAppenders();
            FileAppender fileAppender = new FileAppender((Layout)new PatternLayout(), outputFile);
            outputFileLogger.addAppender((Appender)fileAppender);
            outputFileLogger.setLevel(Level.DEBUG);
        }
        catch (IOException ioe) {
            logger.info((Object)"output directory not supplied");
        }
        catch (ExceptionInInitializerError eii) {
            logger.info((Object)"initialization exception in creting output logger");
        }
    }

    static {
        errorFileLogger = Logger.getLogger((String)"Instance Errors");
        outputFileLogger = Logger.getLogger((String)"Instance Output");
    }
}

