/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server.extractor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.eaglei.datatools.etl.server.exceptions.ExtractorException;
import org.eaglei.datatools.etl.server.extractor.parsers.Data;

public abstract class Extractor {
    public abstract String getFormVersion() throws ParseException, IOException;

    public abstract Map<String, Data> getData(File var1) throws ConfigurationException, IOException, ParseException, ExtractorException;

    public Map<String, File> getMapFiles(File mapDirectory) throws FileNotFoundException {
        String[] lstMapFiles;
        HashMap<String, File> mapIns = new HashMap<String, File>();
        for (String mapFileName : lstMapFiles = mapDirectory.list()) {
            if (mapFileName.contains(".svn")) continue;
            File mapFile = new File(mapDirectory.getPath() + "/" + mapFileName);
            mapIns.put(mapFileName.replace(".rdf", "").toUpperCase(), mapFile);
        }
        return mapIns;
    }

    public File getMapDirectory(String formVersion, File mapsParentDirectory) {
        return new File(mapsParentDirectory.getPath() + "/" + formVersion);
    }
}

