/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server.extractor;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.exceptions.NotADirectoryException;

public class FileIterator
implements Iterator<File> {
    private String directoryPath;
    private File directory;
    private List<String> childFiles;
    private List<FileIterator> subDirectoriesIteratorsList;
    int index = 0;
    int subDirecotryIndex = 0;
    private static Logger logger = Logger.getLogger(FileIterator.class);

    public FileIterator(String directoryPath) throws NotADirectoryException {
        this.directoryPath = directoryPath;
        this.childFiles = new ArrayList<String>();
        this.subDirectoriesIteratorsList = new ArrayList<FileIterator>();
        this.directory = new File(directoryPath);
        if (!this.directory.isDirectory()) {
            logger.error((Object)(directoryPath + " is not a directory...exiting"));
            throw new NotADirectoryException("Expecting directory but the supplied is a path of file");
        }
        this.childFiles = Arrays.asList(this.directory.list());
    }

    @Override
    public boolean hasNext() {
        if (this.index + 1 > this.childFiles.size() && this.subDirectoriesIteratorsList.size() == 0) {
            return false;
        }
        return this.subDirectoriesIteratorsList.size() == 0 || this.subDirecotryIndex != this.subDirectoriesIteratorsList.size() - 1 || this.subDirectoriesIteratorsList.get(this.subDirecotryIndex).hasNext();
    }

    @Override
    public File next() {
        try {
            return this.getNextFile();
        }
        catch (FileNotFoundException ex) {
            logger.error((Object)"FileNotFoundExeption in getting next file, continuing onto getting other files");
            return this.next();
        }
        catch (NotADirectoryException ex) {
            logger.error((Object)"NotADirectory in getting next file, continuing onto getting other files");
            return this.next();
        }
    }

    @Override
    public void remove() {
    }

    private File getNextFile() throws FileNotFoundException, NotADirectoryException {
        if (this.index <= this.childFiles.size() - 1) {
            String childFileString = this.childFiles.get(this.index++);
            String fullFilePath = this.directoryPath + "/" + childFileString;
            File childFile = new File(fullFilePath);
            if (childFile.isDirectory()) {
                this.subDirectoriesIteratorsList.add(new FileIterator(fullFilePath));
                return this.getNextFile();
            }
            return childFile;
        }
        return this.getNextSubDirectoriesFile();
    }

    private File getNextSubDirectoriesFile() {
        File lastSubDirecotry;
        if (this.subDirectoriesIteratorsList.size() == 1) {
            lastSubDirecotry = this.subDirectoriesIteratorsList.get(0).next();
        } else if (this.subDirecotryIndex == this.subDirectoriesIteratorsList.size() - 1) {
            lastSubDirecotry = this.subDirectoriesIteratorsList.get(this.subDirecotryIndex).next();
        } else {
            if (this.subDirectoriesIteratorsList.get(this.subDirecotryIndex).hasNext()) {
                return this.subDirectoriesIteratorsList.get(this.subDirecotryIndex).next();
            }
            ++this.subDirecotryIndex;
            return this.getNextSubDirectoriesFile();
        }
        return lastSubDirecotry;
    }
}

