/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server.extractor.parsers.xmlparser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.configuration.ConfigurationException;
import org.eaglei.datatools.etl.server.BROOntologyReasoner;
import org.eaglei.datatools.etl.server.exceptions.ExtractorException;
import org.eaglei.datatools.etl.server.extractor.parsers.Data;
import org.eaglei.datatools.etl.server.extractor.parsers.EIFileParser;
import org.eaglei.datatools.etl.server.extractor.parsers.MapFileConfiguration;
import org.eaglei.datatools.etl.server.extractor.parsers.xmlparser.XmlFileConfiguration;
import org.eaglei.datatools.etl.utils.BasicUtils;
import org.eaglei.datatools.etl.utils.ETLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlFileParser
extends EIFileParser<Map<String, Data>> {
    private File xmlFile;
    private Document xmlDoc;
    private String contextNode;
    private Map<String, String> namespaceMap;
    BROOntologyReasoner BROreasoner;

    public XmlFileParser(File xmlFile) throws ParserConfigurationException, SAXException, IOException {
        this.xmlFile = xmlFile;
        this.xmlDoc = this.getXmlDocument(xmlFile);
        this.BROreasoner = new BROOntologyReasoner();
    }

    @Override
    public Map<String, Data> parse(File mapDirectory) throws ConfigurationException, IOException, ParseException, ExtractorException {
        HashMap<String, Data> dataMap = new HashMap<String, Data>();
        try {
            String[] mapFileOrder;
            for (String mapFile : mapFileOrder = MapFileConfiguration.getOrderofMapFiles(mapDirectory.getPath())) {
                this.contextNode = XmlFileConfiguration.getContextNode(mapDirectory.getPath());
                Set<String> expressionSet = this.getExpressionSetofMapFile(mapDirectory, mapFile);
                List<String> expressionList = Arrays.asList(expressionSet.toArray(new String[expressionSet.size()]));
                List<XPathExpression> xpathExpressionSet = this.getXPathExpressionsList(expressionList);
                Data data = this.makeDataByExpressionSet(xpathExpressionSet, expressionList);
                dataMap.put(mapFile.toUpperCase(), data);
            }
        }
        catch (XPathExpressionException e) {
            throw new ExtractorException(e);
        }
        return dataMap;
    }

    public Map<String, String> getAllNamespacesFromXmlDocument() throws IOException {
        boolean PREFIX = true;
        int URI2 = 2;
        this.namespaceMap = new HashMap<String, String>();
        FileInputStream fileInputStream = new FileInputStream(this.xmlFile);
        String xmlString = BasicUtils.convertStreamToString(fileInputStream);
        Pattern instancePattern = Pattern.compile("xmlns:([^=].*?)=\"([^\"]*?)\"", 2);
        Matcher match = instancePattern.matcher(xmlString);
        while (match.find()) {
            int count = match.groupCount();
            this.namespaceMap.put(match.group(1), match.group(2));
        }
        return this.namespaceMap;
    }

    private Set<String> getExpressionSetofMapFile(File mapDirectory, String mapFile) throws FileNotFoundException, IOException {
        FileInputStream mapStream = new FileInputStream(mapDirectory.getPath() + "\\" + mapFile + ".rdf");
        Set<String> expressionSet = ETLUtils.getExpressionsInMapFile(mapStream);
        return expressionSet;
    }

    private Document getXmlDocument(File xmlFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = fact.newDocumentBuilder();
        Document doc = builder.parse(xmlFile);
        return doc;
    }

    private List<XPathExpression> getXPathExpressionsList(List<String> expressionList) throws XPathExpressionException, IOException {
        XPath xpath = this.getXpath();
        ArrayList<XPathExpression> xpathExpressionSet = new ArrayList<XPathExpression>();
        for (String mapExpression : expressionList) {
            XPathExpression xpathExpression = xpath.compile(mapExpression);
            xpathExpressionSet.add(xpathExpression);
        }
        return xpathExpressionSet;
    }

    private XPath getXpath() throws IOException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(this.getNamespaceContextOfCurrentDocument());
        return xpath;
    }

    private NamespaceContext getNamespaceContextOfCurrentDocument() throws IOException {
        final Map<String, String> nameSpaceMap = this.getAllNamespacesFromXmlDocument();
        NamespaceContext namespaceContext = new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                return (String)nameSpaceMap.get(prefix);
            }

            @Override
            public String getPrefix(String namespaceURI) {
                throw new UnsupportedOperationException();
            }

            public Iterator getPrefixes(String namespaceURI) {
                throw new UnsupportedOperationException();
            }
        };
        return namespaceContext;
    }

    private Data makeDataByExpressionSet(List<XPathExpression> xPathExpressionList, List<String> mapExpressionList) throws XPathExpressionException, IOException {
        List<Map<Node, String[]>> allElementsList = this.extractElementsFromXML(xPathExpressionList, mapExpressionList);
        Data data = this.getDataFromAllColumns(mapExpressionList, allElementsList);
        return data;
    }

    private Data getDataFromAllColumns(List<String> mapExpressionList, List<Map<Node, String[]>> allElementsList) throws XPathExpressionException, IOException {
        Data data = new Data();
        NodeList contextNodeList = this.getAllContextNodes();
        for (int y = 0; y <= contextNodeList.getLength() - 1; ++y) {
            Node contextNode = contextNodeList.item(y);
            Vector<String[]> columnVector = this.getRowVector(contextNode, allElementsList);
            if (data.getColumnCount() < columnVector.size()) {
                data.setColumnCount(columnVector.size());
            }
            data.addRow(columnVector);
        }
        return data;
    }

    private Vector<String[]> getRowVector(Node contextNode, List<Map<Node, String[]>> allElementsList) {
        Vector<String[]> rowVector = new Vector<String[]>();
        for (Map<Node, String[]> columnMap : allElementsList) {
            Set<Node> NodeSet = columnMap.keySet();
            this.loopNodeSetAndInRowVector(contextNode, rowVector, columnMap, NodeSet);
        }
        return rowVector;
    }

    private void loopNodeSetAndInRowVector(Node contextNode, Vector<String[]> rowVector, Map<Node, String[]> columnMap, Set<Node> NodeSet) {
        for (Node keyNode : NodeSet) {
            if (!keyNode.isEqualNode(contextNode)) continue;
            rowVector.add(columnMap.get(keyNode));
        }
    }

    private List<Map<Node, String[]>> extractElementsFromXML(List<XPathExpression> xPathExpressionList, List<String> mapExpressionList) throws FileNotFoundException, XPathExpressionException {
        ArrayList<Map<Node, String[]>> allElementsList = new ArrayList<Map<Node, String[]>>();
        int i = 0;
        for (XPathExpression xpathExpression : xPathExpressionList) {
            NodeList nodeList = this.evaluateXpathExpression(xpathExpression);
            Map<Node, String[]> elementList = this.getMapFromNodeList(nodeList, mapExpressionList.get(i));
            allElementsList.add(elementList);
            ++i;
        }
        return allElementsList;
    }

    private NodeList evaluateXpathExpression(XPathExpression xpathExpression) throws FileNotFoundException, XPathExpressionException {
        FileInputStream fileInputStream = new FileInputStream(this.xmlFile);
        NodeList columns = (NodeList)xpathExpression.evaluate(new InputSource(fileInputStream), XPathConstants.NODESET);
        return columns;
    }

    private Map<Node, String[]> getMapFromNodeList(NodeList columns, String mapExpression) {
        HashMap<Node, String[]> nodeMap = new HashMap<Node, String[]>();
        for (int i = 0; i < columns.getLength(); ++i) {
            this.prepareMapWithParentNodeAsKey(columns.item(i), mapExpression, nodeMap);
        }
        return nodeMap;
    }

    private void prepareMapWithParentNodeAsKey(Node node, String mapExpression, Map<Node, String[]> nodeMap) {
        Node currentContextNode = this.getContextNodeOfTheCurrentNode(node);
        if (nodeMap.get(currentContextNode) != null) {
            String[] aryOfExpressionAndValue = nodeMap.get(currentContextNode);
            if (mapExpression.contains("desc:resource_type")) {
                String broResource = node.getFirstChild().getNextSibling().getNodeName().replace("BRO:", "http://bioontology.org/ontologies/BiomedicalResourceOntology.owl#");
                aryOfExpressionAndValue[1] = aryOfExpressionAndValue[1] + ";" + this.BROreasoner.getEagleIResource(broResource);
            } else {
                aryOfExpressionAndValue[1] = aryOfExpressionAndValue[1] + ";" + node.getFirstChild().getNodeValue();
            }
        } else {
            String[] aryOfExpressionAndValue = new String[2];
            aryOfExpressionAndValue[0] = mapExpression;
            if (mapExpression.contains("desc:resource_type")) {
                String broResource = node.getFirstChild().getNextSibling().getNodeName().replace("BRO:", "http://bioontology.org/ontologies/BiomedicalResourceOntology.owl#");
                aryOfExpressionAndValue[1] = this.BROreasoner.getEagleIResource(broResource);
            } else {
                aryOfExpressionAndValue[1] = node.getFirstChild().getNodeValue();
            }
            nodeMap.put(currentContextNode, aryOfExpressionAndValue);
        }
    }

    private Node getContextNodeOfTheCurrentNode(Node currentNode) {
        Node parentNode = currentNode.getParentNode();
        if (!parentNode.getNodeName().equalsIgnoreCase(this.contextNode)) {
            parentNode = this.getContextNodeOfTheCurrentNode(parentNode);
        }
        return parentNode;
    }

    private NodeList getAllContextNodes() throws XPathExpressionException, IOException {
        XPathExpression xpathExpression = this.getXpath().compile("//" + this.contextNode);
        NodeList contextList = this.evaluateXpathExpression(xpathExpression);
        return contextList;
    }
}

