/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server.loader;

import com.hp.hpl.jena.rdf.model.Statement;
import java.util.Arrays;
import org.eaglei.datatools.etl.server.ETLEntryPoint;
import org.eaglei.datatools.etl.server.RepoService;
import org.eaglei.datatools.etl.server.exceptions.LoaderException;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.model.EIURI;

public abstract class Loader {
    public abstract void load(Statement[] var1, String var2, Promote var3) throws LoaderException;

    protected boolean workFlowTansistion(EIURI resource, Promote promote) throws Exception {
        RepoService repoService = ETLEntryPoint.getInstance().getRepoService();
        RepositoryProvider repoProvider = ETLEntryPoint.getInstance().getRepoService().getRepositoryProvider();
        if (promote == Promote.PUBLISH) {
            repoProvider.transition(repoService.getSession(), Arrays.asList(resource), RepoService.SENT_TO_CURATION_TRANSITION);
            repoProvider.claim(repoService.getSession(), Arrays.asList(resource));
            repoProvider.transition(repoService.getSession(), Arrays.asList(resource), RepoService.PUBLISH_TRANSITION);
            return true;
        }
        if (promote == Promote.CURATION) {
            repoProvider.transition(repoService.getSession(), Arrays.asList(resource), RepoService.DEFAULT_CREATE_TRANSITION);
            repoProvider.transition(repoService.getSession(), Arrays.asList(resource), RepoService.SENT_TO_CURATION_TRANSITION);
            repoProvider.release(repoService.getSession(), Arrays.asList(resource));
            return true;
        }
        if (promote == Promote.DRAFT) {
            repoProvider.release(repoService.getSession(), Arrays.asList(resource));
            return true;
        }
        return false;
    }

    public static enum Promote {
        DRAFT,
        CURATION,
        PUBLISH;


        public static Promote getPromote(String promoteParameter) {
            if (promoteParameter.equals(CURATION.toString())) {
                return CURATION;
            }
            if (promoteParameter.equals(PUBLISH.toString())) {
                return PUBLISH;
            }
            return DRAFT;
        }
    }
}

