/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server.loader;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.LoggerFactory;
import org.eaglei.datatools.etl.server.RepoService;
import org.eaglei.datatools.etl.server.exceptions.LoaderException;
import org.eaglei.datatools.etl.server.loader.Loader;
import org.eaglei.datatools.etl.server.loader.Validation;
import org.eaglei.datatools.model.AnnotationFormModel;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIInstanceFactory;

public class LoaderImpl
extends Loader {
    private static Logger logger = Logger.getLogger(LoaderImpl.class);
    private Validation validation;
    private RepoService repoService;
    private JenaEIInstanceFactory jenaIntanceFactory;
    private AnnotationFormModel anntModel;

    public LoaderImpl(RepoService repoService, JenaEIInstanceFactory jenaIntanceFactory, AnnotationFormModel anntModel) {
        this.repoService = repoService;
        this.jenaIntanceFactory = jenaIntanceFactory;
        this.anntModel = anntModel;
        this.validation = new Validation(repoService);
    }

    @Override
    public void load(Statement[] statements, String sourceFile, Loader.Promote promoteParameter) throws LoaderException {
        try {
            Model rdfModel = null;
            rdfModel = ModelFactory.createDefaultModel();
            rdfModel.add(statements);
            StringWriter swriter = new StringWriter();
            rdfModel.write((Writer)swriter, "RDF/XML");
            List lstInstance = this.jenaIntanceFactory.create(rdfModel);
            for (EIInstance instance : lstInstance) {
                EIInstance instanceTopush = this.jenaIntanceFactory.createExtended(instance.getInstanceURI(), rdfModel);
                if (this.validation.isEmbeddedClass(instanceTopush.getInstanceClass(), this.anntModel.getDatatoolsEIOntModel())) continue;
                this.addSourcefileProperty(instanceTopush, sourceFile);
                if (this.validation.isLab(instanceTopush) && !this.validation.isInstanceLableAndTypeAlreadyExsistsInRepository(instanceTopush)) {
                    this.push(this.repoService, instanceTopush, promoteParameter);
                    continue;
                }
                if (this.validation.isLab(instanceTopush)) continue;
                this.push(this.repoService, instanceTopush, promoteParameter);
            }
            rdfModel.write((Writer)swriter, "RDF/XML");
            LoggerFactory.outputFileLogger.info((Object)swriter.toString());
        }
        catch (IOException ioe) {
            throw new LoaderException("Exception when getting RepoService instance", ioe);
        }
        catch (Exception e) {
            throw new LoaderException(e);
        }
    }

    private void push(RepoService repoService, EIInstance instance, Loader.Promote promoteParameter) throws LoaderException {
        try {
            repoService.pushToRepo(instance);
            this.workFlowTansistion(instance.getInstanceURI(), promoteParameter);
        }
        catch (Exception e) {
            throw new LoaderException(e);
        }
    }

    private void push(RepoService repoService, String rdfString, String instanceUri, Loader.Promote promoteParameter) throws LoaderException {
        try {
            repoService.pushToRepo(rdfString, instanceUri);
        }
        catch (Exception e) {
            throw new LoaderException(e);
        }
    }

    private void addSourcefileProperty(EIInstance instance, String sourceFile) {
        EIEntity property = EIEntity.create((EIURI)EIURI.create((String)"http://eagle-i.org/ont/datatools/1.0/source_file"), (String)sourceFile);
        instance.addNonOntologyLiteralProperty(property, sourceFile);
    }
}

