/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server.loader;

import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.RepoService;
import org.eaglei.datatools.etl.utils.ETLSPARQLQueryUtil;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.jena.SPARQLQueryUtil;
import org.eaglei.services.repository.RepositoryProviderException;

public class Validation {
    private static Logger logger = Logger.getLogger(Validation.class);
    private RepoService repoService;

    public Validation(RepoService repoService) {
        this.repoService = repoService;
    }

    public boolean isInstanceLableAndTypeAlreadyExsistsInRepository(EIInstance instance) throws Exception {
        try {
            String query = SPARQLQueryUtil.getInstance().getEIResourcesByLabelQuery(instance.getInstanceType().getURI(), instance.getInstanceLabel());
            String results = this.repoService.query(query.replace("\n", " ").replace("\r", " "));
            String[] instanceURI = ETLSPARQLQueryUtil.getInstanceURI(results);
            return instanceURI.length > 0;
        }
        catch (RepositoryProviderException ex) {
            logger.error((Object)ex.getMessage());
            logger.error((Object)("the offending instnace is " + instance.getInstanceType().getURI()));
            logger.info((Object)"skiping...");
            throw ex;
        }
    }

    public boolean isLab(EIInstance instance) {
        EIClass instanceClass = instance.getInstanceClass();
        if (instanceClass.getEntity().getURI().toString().equals("http://purl.obolibrary.org/obo/ERO_0000001")) {
            return true;
        }
        List superEIClassList = instanceClass.getSuperClasses();
        if (superEIClassList == null) {
            return false;
        }
        for (EIClass superClass : superEIClassList) {
            if (!superClass.getEntity().getURI().toString().equals("http://purl.obolibrary.org/obo/ERO_0000001")) continue;
            return true;
        }
        return false;
    }

    public boolean isEmbeddedClass(EIClass eiClass, EIOntModel eiOntModel) {
        Set annotationSet = eiOntModel.getClassAnnotations(eiClass.getEntity().getURI());
        if (annotationSet == null) {
            return false;
        }
        for (String annotationString : annotationSet) {
            if (!annotationString.contains("ClassGroup_embedded_class")) continue;
            return true;
        }
        return false;
    }
}

