/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server.transformer;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.ETLRepositoryConfiguration;
import org.eaglei.datatools.etl.server.RepoService;
import org.eaglei.datatools.etl.server.transformer.Expression;
import org.eaglei.datatools.etl.server.transformer.MapInterpreter;
import org.eaglei.datatools.etl.server.transformer.SemiColonExpresson;
import org.eaglei.datatools.etl.utils.ETLSPARQLQueryUtil;
import org.eaglei.datatools.etl.utils.ETLUtils;
import org.eaglei.datatools.model.AnnotationFormModel;

public class ResourceExpression
extends Expression<Statement[]> {
    public static final String RESOURCE_EXPRESSION_MATCHER = "Ex:e+$";
    private String subectExpression;
    private Map<String, String> columnMap;
    private Statement mapStatement;
    private Model mapModel;
    private RepoService repoService;
    private AnnotationFormModel anntModel;
    private static Logger logger = Logger.getLogger(ResourceExpression.class);

    public ResourceExpression(String subectExpression, Map<String, String> columnMap, Statement mapStatement, Model mapModel, AnnotationFormModel anntModel, RepoService repoService) {
        this.subectExpression = subectExpression;
        this.columnMap = columnMap;
        this.mapStatement = mapStatement;
        this.mapModel = mapModel;
        this.repoService = repoService;
        this.anntModel = anntModel;
    }

    @Override
    public Statement[] interpret() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("the interpreting expression string is " + this.subectExpression));
        }
        if (this.subectExpression.equals("Ex:e+$NEW_INSTANCE")) {
            return new Statement[]{this.mapStatement};
        }
        Model subNodeMapModel = this.checkForDcCreatorAndWrap(ETLUtils.getsubModelByExpression(this.subectExpression, this.mapModel));
        SemiColonExpresson semiColonExpression = new SemiColonExpresson(subNodeMapModel, this.columnMap);
        Model[] modelAfterSemiColonInterpretation = semiColonExpression.interpret();
        ArrayList<Statement> statementList = new ArrayList<Statement>();
        for (Model model : modelAfterSemiColonInterpretation) {
            Statement[] statementAry = this.interpretResourceExpressionAfterSemicolon(model);
            if (statementAry == null) continue;
            statementList.addAll(Arrays.asList(statementAry));
        }
        return statementList.toArray(new Statement[statementList.size()]);
    }

    private Model checkForDcCreatorAndWrap(Model dcModel) {
        try {
            if (this.mapStatement.getPredicate().getURI().equalsIgnoreCase("http://purl.org/dc/terms/creator")) {
                Map<String, String> dcCreatorMap = ETLRepositoryConfiguration.getdcCreatorFromRepoFile(this.repoService.getRepoConfigFile());
                String result = ETLUtils.evaluateExpression(this.columnMap, this.subectExpression.split("\\+")[1]);
                result = this.wrapUsersofdcCreator(result, dcCreatorMap);
                StmtIterator stmtIter = dcModel.listStatements();
                Statement labelStatement = null;
                while (stmtIter.hasNext()) {
                    Statement statement = (Statement)stmtIter.next();
                    if (!statement.getPredicate().equals(RDFS.label)) continue;
                    labelStatement = statement;
                }
                if (labelStatement != null) {
                    dcModel.remove(labelStatement);
                    Statement newStatement = labelStatement.changeObject(result);
                    dcModel.add(newStatement);
                }
            }
            return dcModel;
        }
        catch (Exception e) {
            logger.error((Object)"Exception Exception Occured in interpret method of ResourceExpression class while reading DcCreator for config file");
            throw new RuntimeException(e);
        }
    }

    private Statement[] interpretResourceExpressionAfterSemicolon(Model subNodeMapModel) {
        try {
            MapInterpreter subNodeMapEvaluator = new MapInterpreter(this.mapModel, subNodeMapModel, this.columnMap, this.subectExpression.toString(), this.mapStatement, this.anntModel, this.repoService);
            Statement[] statementAry = subNodeMapEvaluator.interpret();
            if (statementAry.length <= 1 || !ETLUtils.isLabelPresentInMap(statementAry)) {
                return null;
            }
            Model tempModel = ModelFactory.createDefaultModel();
            tempModel.add(statementAry);
            String query = "";
            query = ETLUtils.getTypeOfModel(tempModel).contains("person") || ETLUtils.getTypeOfModel(tempModel).contains("Person") ? ETLSPARQLQueryUtil.getEIResourcesByOnlyTypeANDRdfsLabel(tempModel) : ETLSPARQLQueryUtil.getEIResourcesByAllPropertiesQuery(this.repoService.getRepositoryProvider(), tempModel, this.repoService.getSession());
            logger.debug((Object)("the query for Resource in Resource Expression class " + query));
            String instance = this.repoService.getRepositoryProvider().query(this.repoService.getSession(), query.replace("\n", " ").replace("\r", " "));
            String[] instanceURI = ETLSPARQLQueryUtil.getInstanceURI(instance);
            Resource subject = this.repoService.getNewResourceFromRepository(tempModel);
            if (instanceURI.length == 0) {
                List<Statement> statementList = ETLUtils.replaceExpressionWithURI(statementAry, subject, this.subectExpression);
                Statement statementOfMainInstance = tempModel.createStatement(this.mapStatement.getSubject(), this.mapStatement.getPredicate(), (RDFNode)subject);
                statementList.add(statementOfMainInstance);
                return statementList.toArray(new Statement[statementList.size()]);
            }
            Resource typeObject = tempModel.createResource(instanceURI[0]);
            Statement stmtToReturn = tempModel.createStatement(this.mapStatement.getSubject(), this.mapStatement.getPredicate(), (RDFNode)typeObject);
            return new Statement[]{stmtToReturn};
        }
        catch (IOException ioe) {
            logger.error((Object)("IO Exception Occured in interpret method of ResourceExpression class while interpreting " + this.mapStatement.getObject()));
            logger.error((Object)ioe);
            throw new RuntimeException(ioe);
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            logger.error((Object)("ArrayIndexOutOfBounds Exception  Occured in interpret method of ResourceExpressio's interpret method " + this.mapStatement.getObject()));
            logger.error((Object)aie);
            System.exit(2);
            throw new RuntimeException(aie);
        }
        catch (Exception e) {
            logger.error((Object)(" Exception Occured in interpret method of ResourceExpression class" + this.mapStatement.getObject()));
            logger.error((Object)e);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private String wrapUsersofdcCreator(String result, Map<String, String> dcCreatorMap) throws ConfigurationException {
        if (dcCreatorMap.get(result.replace(" ", "")) != null) {
            return dcCreatorMap.get(result.replace(" ", ""));
        }
        return result;
    }

    @Override
    public String getExpressionString() {
        return this.subectExpression;
    }

    @Override
    public Statement getExpressionStatement() {
        return this.mapStatement;
    }
}

