/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.utils;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.utils.BasicUtils;

public class ETLUtils {
    private static Logger logger = Logger.getLogger(ETLUtils.class);

    public static Model getsubModelByExpression(String expression, Model rdfModel) {
        Model modelToReturn = ModelFactory.createDefaultModel();
        StmtIterator subIter = rdfModel.listStatements();
        while (subIter.hasNext()) {
            Statement stmtMap = subIter.nextStatement();
            Resource subjectMap = stmtMap.getSubject();
            if (!subjectMap.getURI().equals(expression)) continue;
            modelToReturn.add(stmtMap);
        }
        return modelToReturn;
    }

    public static boolean isSubjectExpressionPresentInModel(String expression, Model rdfModel) {
        StmtIterator subIter = rdfModel.listStatements();
        while (subIter.hasNext()) {
            Statement stmtMap = subIter.nextStatement();
            Resource subjectMap = stmtMap.getSubject();
            if (!subjectMap.getURI().equals(expression)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLabelPresentInMap(Model rdfModel) {
        StmtIterator subIter = rdfModel.listStatements();
        while (subIter.hasNext()) {
            Statement stmtMap = subIter.nextStatement();
            Property property = stmtMap.getPredicate();
            if (!property.equals(RDFS.label)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLabelPresentInMap(Statement[] statementAry) {
        for (Statement statement : statementAry) {
            Property property = statement.getPredicate();
            if (!property.equals(RDFS.label)) continue;
            return true;
        }
        return false;
    }

    public static String getTypeOfModel(Model rdfModel) throws NoSuchFieldException {
        StmtIterator subIter = rdfModel.listStatements();
        while (subIter.hasNext()) {
            Statement stmtMap = subIter.nextStatement();
            Property property = stmtMap.getPredicate();
            if (!property.equals(RDF.type)) continue;
            return stmtMap.getObject().toString();
        }
        throw new NoSuchFieldException("there is not type in the given model");
    }

    public static String evaluateExpression(Map<String, String> columnMap, String expressionString) throws Exception {
        String[] splitedString = expressionString.split("\\$");
        String columnName = splitedString[1];
        String returnString = columnMap.get(columnName.toUpperCase());
        if (returnString != null) {
            return returnString;
        }
        return "";
    }

    public static String[] getLabelAndRootURI(Model tempModel, Map<String, String> columnMap) throws Exception {
        StmtIterator stmtIterator = tempModel.listStatements();
        String[] retString = new String[2];
        while (stmtIterator.hasNext()) {
            String result;
            Statement stmtMap = stmtIterator.nextStatement();
            Resource subjectMap = stmtMap.getSubject();
            Property predicateMap = stmtMap.getPredicate();
            RDFNode objectMap = stmtMap.getObject();
            if (predicateMap.getURI().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) {
                retString[1] = objectMap.toString();
            }
            if (!predicateMap.getURI().equals("http://www.w3.org/2000/01/rdf-schema#label")) continue;
            retString[0] = result = ETLUtils.evaluateExpression(columnMap, objectMap.toString());
        }
        return retString;
    }

    public static List<Statement> replaceExpressionWithURI(Statement[] statementAry, Resource subject, String expressionString) {
        int i = 0;
        ArrayList<Statement> statementList = new ArrayList<Statement>();
        Model tempModel = ModelFactory.createDefaultModel();
        for (Statement statement : statementAry) {
            Statement newStatement;
            if (statement.getSubject().toString().equals(expressionString)) {
                newStatement = tempModel.createStatement(subject, statement.getPredicate(), statement.getObject());
                statementList.add(newStatement);
            } else if (statement.getPredicate().toString().equals(expressionString)) {
                newStatement = tempModel.createStatement(statement.getSubject(), (Property)subject, statement.getObject());
                statementList.add(newStatement);
            } else if (statement.getObject().toString().equals(expressionString)) {
                newStatement = tempModel.createStatement(statement.getSubject(), statement.getPredicate(), (RDFNode)subject);
                statementList.add(newStatement);
            } else {
                statementList.add(statement);
            }
            ++i;
        }
        return statementList;
    }

    public static List<String> getReourceURIFromModel(Model model) {
        ArrayList<String> resourcesList = new ArrayList<String>();
        StringWriter swriter = new StringWriter();
        model.write((Writer)swriter, "RDF/XML");
        Pattern instancePattern = Pattern.compile("<rdf:Description rdf:about=\"(.*?)\">", 2);
        Matcher match = instancePattern.matcher(swriter.toString());
        while (match.find()) {
            int count = match.groupCount();
            for (int i = 1; i <= count; ++i) {
                resourcesList.add(match.group(i));
            }
        }
        return resourcesList;
    }

    public static InputStream replaceColumnNamesWithColumnNumbers(InputStream mapStream, Map<String, Integer> columnNameToNumberMap) throws IOException {
        String rdfMapString = BasicUtils.convertStreamToString(mapStream);
        rdfMapString = ETLUtils.formXML(rdfMapString);
        for (Map.Entry<String, Integer> entry : columnNameToNumberMap.entrySet()) {
            String regexedEntryKey = entry.getKey().trim().replaceAll("\\(.+?\\)", "");
            regexedEntryKey = "\\$" + regexedEntryKey.trim().toLowerCase().replaceAll("\\s+", "_").replaceAll("\\B|\\b", "\\\\s*") + "\"";
            regexedEntryKey = "(?iu)" + regexedEntryKey;
            rdfMapString = rdfMapString.replaceAll(regexedEntryKey, "\\$" + entry.getValue().toString() + "\"");
        }
        Pattern instancePattern = Pattern.compile("[^<]*?Ex:\\$([A-Z,a-z,\\W].*?)\".*?/>", 2);
        Matcher match = instancePattern.matcher(rdfMapString);
        while (match.find()) {
            int count = match.groupCount();
            for (int i = 1; i <= count; ++i) {
                rdfMapString = rdfMapString.replaceAll(match.group(i), "SKIP");
            }
        }
        rdfMapString = rdfMapString.replaceAll("Ex:e\\+\\$NEW_INSTANCE", "Ex:e\\+\\$0");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("the converted RDF string is " + rdfMapString));
        }
        ByteArrayInputStream returnInputStream = new ByteArrayInputStream(rdfMapString.getBytes());
        return returnInputStream;
    }

    public static Set<String> getExpressionsInMapFile(InputStream mapStream) throws IOException {
        String rdfMapString = BasicUtils.convertStreamToString(mapStream);
        rdfMapString = ETLUtils.formXML(rdfMapString);
        HashSet<String> setToReturn = new HashSet<String>();
        Pattern instancePattern = Pattern.compile("[^<]*?Ex:\\$([A-Z,a-z,\\W].*?)\".*?/>", 2);
        Matcher match = instancePattern.matcher(rdfMapString);
        while (match.find()) {
            int count = match.groupCount();
            for (int i = 1; i <= count; ++i) {
                setToReturn.add(match.group(i));
            }
        }
        return setToReturn;
    }

    public static String formXML(String aText) {
        String returnText = aText.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"").replaceAll("&apos;", "'").replaceAll("&amp;", "&");
        return returnText;
    }

    public static String forRegex(String aRegexFragment) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aRegexFragment);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '.') {
                result.append("\\\\.");
            } else if (character == '\\') {
                result.append("\\\\\\");
            } else if (character == '?') {
                result.append("\\\\?");
            } else if (character == '*') {
                result.append("\\\\*");
            } else if (character == '+') {
                result.append("\\\\+");
            } else if (character == '&') {
                result.append("\\\\&");
            } else if (character == ':') {
                result.append("\\\\:");
            } else if (character == '{') {
                result.append("\\\\{");
            } else if (character == '}') {
                result.append("\\\\}");
            } else if (character == '[') {
                result.append("\\\\[");
            } else if (character == ']') {
                result.append("\\\\]");
            } else if (character == '(') {
                result.append("\\\\(");
            } else if (character == ')') {
                result.append("\\\\)");
            } else if (character == '^') {
                result.append("^");
            } else if (character == '$') {
                result.append("\\\\$");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }
}

