/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.excel;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.eaglei.datatools.excel.ExcelParserException;

public class ExcelUtils {
    private static final Log logger = LogFactory.getLog(ExcelUtils.class);

    public static Workbook openWorkBook(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            logger.error((Object)"File name null or empty");
            throw new IllegalArgumentException("File name null or empty");
        }
        if (!fileName.endsWith(".xlsx") || fileName.startsWith("~$")) {
            logger.error((Object)("File doesn't look like an Excel file: " + fileName));
            throw new IllegalArgumentException("File doesn't look like an Excel file: ");
        }
        InputStream is = null;
        try {
            Workbook wb;
            is = ClassLoader.getSystemResourceAsStream(fileName);
            Workbook workbook = wb = WorkbookFactory.create((InputStream)is);
            return workbook;
        }
        catch (FileNotFoundException e) {
            throw new ExcelParserException(e);
        }
        catch (InvalidFormatException e) {
            throw new ExcelParserException("Expecting an Excel file", e);
        }
        catch (IOException e) {
            throw new ExcelParserException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static List<Map<String, String>> processTab(Sheet sheet, int startRow) {
        FormulaEvaluator evaluator = sheet.getWorkbook().getCreationHelper().createFormulaEvaluator();
        ArrayList<Map<String, String>> resourceList = new ArrayList<Map<String, String>>();
        ArrayList<String> headers = new ArrayList<String>();
        Row row = sheet.getRow(0);
        if (row == null) {
            throw new ExcelParserException("Tab is missing headers");
        }
        Iterator cIt = row.cellIterator();
        while (cIt.hasNext()) {
            Cell cell = (Cell)cIt.next();
            if (cell == null || cell.getCellType() == 3) continue;
            String header = cell.getStringCellValue();
            int i = header.indexOf("(");
            if (i >= 0) {
                headers.add(header.substring(0, i).trim().replaceAll("\\s{1,}", "_").replaceAll("\\W{1,}", ""));
                continue;
            }
            headers.add(header.trim().replaceAll("\\s{1,}", "_").replaceAll("\\W{1,}", ""));
        }
        int rows = sheet.getPhysicalNumberOfRows();
        for (int r = startRow - 1; r < rows; ++r) {
            row = sheet.getRow(r);
            if (row == null) continue;
            if (row.getPhysicalNumberOfCells() <= 1) break;
            HashMap resourceInstance = new HashMap();
            cIt = row.cellIterator();
            while (cIt.hasNext()) {
                String value;
                Cell cell = (Cell)cIt.next();
                if (cell == null || cell.getCellType() == 3) continue;
                switch (evaluator.evaluateInCell(cell).getCellType()) {
                    case 2: {
                        value = cell.getCellFormula();
                        break;
                    }
                    case 0: {
                        value = String.valueOf(Double.valueOf(cell.getNumericCellValue()).intValue());
                        break;
                    }
                    case 1: {
                        value = cell.getStringCellValue();
                        break;
                    }
                    default: {
                        value = null;
                    }
                }
                int colIndex = cell.getColumnIndex();
                if (colIndex < headers.size()) {
                    if (value == null || value.length() <= 0) continue;
                    resourceInstance.put(headers.get(cell.getColumnIndex()), value.replaceAll("\\n{1,}", " ").trim());
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Cell without column header; Value: " + value));
            }
            if (resourceInstance.isEmpty()) continue;
            resourceList.add(resourceInstance);
        }
        return resourceList;
    }

    public static boolean isBlankRow(Row row) {
        if (row != null) {
            Iterator cellIter = row.cellIterator();
            while (cellIter.hasNext()) {
                Cell cell = (Cell)cellIter.next();
                if (cell.getCellType() == 3) continue;
                return false;
            }
        }
        return true;
    }
}

