/**
 * 
 */
package org.eaglei.datatools.etl.utils;

import java.util.Arrays;

import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.RepoService;
import org.eaglei.datatools.etl.server.loader.Loader.Promote;
import org.eaglei.datatools.model.AnnotationFormModel;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIInstanceFactory;
import org.eaglei.services.repository.SecurityProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/**
 * @author Sravan Cheriyala
 * 
 */
public class BulkWorkFlow extends BulkOperation {

	private static org.apache.log4j.Logger logger = Logger.getLogger( DeETL.class );
	private static String fileName;
	private static String repo;
	private static Promote promoteParameter;
	public static RepoService rdftorepo;

	public static void main(String args[]) throws Exception {

		for (int i = 0; i < args.length - 1; i++) {
			if ( args[i].equals( "-f" ) ) {
				i = i + 1;
				fileName = args[i];
			} else if ( args[i].equals( "-r" ) ) {
				i = i + 1;
				repo = args[i];
			} else if ( args[i].equals( "-p" ) ) {
				i = i + 1;
				promoteParameter = Promote.getPromote( args[i] );
			}

		}

		// create and configure spring beans
		final ApplicationContext context = new ClassPathXmlApplicationContext( new String[] { "datatools-model-config.xml" } );
	
		JenaEIInstanceFactory jenaInstanceFactory = context.getBean( JenaEIInstanceFactory.class );
		SecurityProvider generalSecurityProvider = context.getBean( SecurityProvider.class );
		BulkWorkFlow bulkworkflow = new BulkWorkFlow( repo,jenaInstanceFactory,generalSecurityProvider );
		bulkworkflow.promote( promoteParameter );

	}

	/**
	 * Constructor where we get the ReposiotryProvider object and also gets session by loging into reposiotry
	 * 
	 * @throws Exception
	 */
	public BulkWorkFlow(String repo,JenaEIInstanceFactory jenaInstanceFactory,SecurityProvider securityProvider) throws Exception {

		super( repo,jenaInstanceFactory,securityProvider );
	}

	public void promote(Promote promote) {

		String[] instanceURIAry = getResourcesOfFile( fileName );
		int i = 0;
		for (String instanceURI : instanceURIAry) {
			try {

				this.getRdftorepo().getRepositoryProvider().claim( this.getRdftorepo().getSession(), Arrays.asList( EIURI.create( instanceURI ) ) );
				this.getRdftorepo().workFlowTansistion( Arrays.asList( EIURI.create( instanceURI ) ), promote );
				i++;
				if ( i % 50 == 0 ) {
					System.gc();
				}
			} catch (Exception e) {
				logger.error( "There is Error in deleting this resource" + instanceURI );
				continue;
			}

		}
		if ( i == 0 ) {
			logger.info( "There are no resources with this file to delete" );
		}

	}

}
