/**
 * 
 */
package org.eaglei.datatools.etl.server;

import java.io.IOException;

import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

/**
 * @author Sravan Cheriyala
 * 
 */
public class LoggerFactory {

	private static org.apache.log4j.Logger logger = Logger.getLogger( LoggerFactory.class );
	private static LoggerFactory loggerFactory;
	public static Logger errorFileLogger = Logger.getLogger( "Instance Errors" );
	public static Logger outputFileLogger = Logger.getLogger( "Instance Output" );

	public static void intializeLoggers(String errorFile, String outputFile) {
		if ( loggerFactory == null ) {
			loggerFactory = new LoggerFactory();

		}

	}

	private LoggerFactory() {

	}

	public static void appendErrorFileToLogger(String errorFile) {
		try {
			errorFileLogger.removeAllAppenders();
			Appender errorFileAppender = new FileAppender( new PatternLayout(), errorFile );
			errorFileLogger.addAppender( errorFileAppender );
			errorFileLogger.setLevel( Level.DEBUG );

		} catch (IOException ioe) {
			logger.info( "error directory not supplied" );
		} catch (ExceptionInInitializerError eii) {
			logger.info( "initialization exception in creting error logger" );
		}
	}



	public static void appendOutputFileToLogger(String outputFile) {
		try {
			outputFileLogger.removeAllAppenders();
			Appender fileAppender = new FileAppender( new PatternLayout(), outputFile );
			outputFileLogger.addAppender( fileAppender );
			outputFileLogger.setLevel( Level.DEBUG );
		} catch (IOException ioe) {
			logger.info( "output directory not supplied" );
		} catch (ExceptionInInitializerError eii) {
			logger.info( "initialization exception in creting output logger" );
		}

	}

}
