/**
 * 
 */
package org.eaglei.datatools.etl.server.extractor;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;

import javax.xml.parsers.ParserConfigurationException;

import org.eaglei.datatools.etl.server.exceptions.UnsupportedFileException;
import org.eaglei.datatools.etl.server.extractor.parsers.xmlparser.XmlFileParser;
import org.xml.sax.SAXException;

/**
 * @author Sravan Cheriyala
 * 
 */
public class ExtractorFactory {

	public enum ExtractorType {
		excel("xls"), excel2003("xlsx"), xml("xml"), csv("csv"), tsv("tsv"), json("json"),rdf("rdf");

		private String fileExtension;

		ExtractorType(String fileExtention) {
			this.fileExtension = fileExtention;
		}

		public String getExtension() {
			return fileExtension;
		}

	};

	public static Extractor getExtractor(File file) throws ParseException, ParserConfigurationException, SAXException, IOException, UnsupportedFileException {
		ExtractorType extention = getExtention( file );
		// TODO need to implement different exteractors as and when there is requirement,for the moment
		// i am only sending excelExtractor and xml

		if ( extention == ExtractorType.excel || extention == ExtractorType.excel2003 ) {
			return new ExcelExtractor( file );
		} else if ( extention == ExtractorType.xml ) {
			return new XmlExtractor( file, "biositemaps_v1" );
		}
		// TODO:decide if we have to send the excel extrator as default or throw unsupported file extendsion
		else {
			throw new UnsupportedFileException( file.getName() + " is not supported by ETL yet,please send a request at admin@eagle-i.org" );
		}

	}

	private static ExtractorType getExtention(File file) throws UnsupportedFileException {
		String fileName = file.getName();
		int mid = fileName.lastIndexOf( "." );
		String fname = fileName.substring( 0, mid );
		String ext = fileName.substring( mid + 1, fileName.length() );
		if ( ext.equals( ExtractorType.excel.getExtension() ) ) {
			return ExtractorType.excel;
		}
		if ( ext.equals( ExtractorType.excel2003.getExtension() ) ) {
			return ExtractorType.excel2003;
		} else if ( ext.equals( ExtractorType.xml.getExtension() ) || ext.equals( ExtractorType.rdf.getExtension() )) {
			return ExtractorType.xml;
		} else if ( ext.equals( ExtractorType.csv.getExtension() ) ) {
			return ExtractorType.csv;
		} else if ( ext.equals( ExtractorType.tsv.getExtension() ) ) {
			return ExtractorType.tsv;
		} else if ( ext.equals( ExtractorType.json.getExtension() ) ) {
			return ExtractorType.json;
		}
		else
		{
			throw new UnsupportedFileException( file.getName() + " is not supported by ETL yet,please send a request at admin@eagle-i.org" );
		}

	}
}
