/**
 * 
 */
package org.eaglei.datatools.etl.server.loader;

import java.util.Arrays;

import org.eaglei.datatools.etl.server.ETLEntryPoint;
import org.eaglei.datatools.etl.server.RepoService;
import org.eaglei.datatools.etl.server.exceptions.LoaderException;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.model.EIURI;

import com.hp.hpl.jena.rdf.model.Statement;

/**
 * 
 * 
 * 
 * 
 * @author Sravan Cheriyala
 */
public abstract class Loader {
	public static enum Promote {
		DRAFT, CURATION, PUBLISH;

		public static Promote getPromote(String promoteParameter) {
			if ( promoteParameter.equals( Loader.Promote.CURATION.toString() ) ) {
				return CURATION;
			} else if ( promoteParameter.equals( Loader.Promote.PUBLISH.toString() ) ) {
				return PUBLISH;
			} else {
				return DRAFT;
			}
		}

	}

	/**
	 * 
	 * loads statements  into repository 
	 * 
	 * @param statements Rdf Statements 
	 * @param sourceFile the filename from which statements are extracted
	 * @param promoteParameter  the possible values of this arguments are DRAFT,CURATION,PUBLISH 
	 * @throws LoaderException
	 */
	public abstract void load(Statement[] statements,String sourceFile,Promote promoteParameter) throws LoaderException;

	
	
	/**
	 * Makes workflow transition 
	 * 
	 * @param resource
	 * @param promote the possible values of this arguments are DRAFT,CURATION,PUBLISH 
	 * @return
	 * @throws Exception
	 */
	protected boolean workFlowTansistion(EIURI resource, Promote promote) throws Exception {
		RepoService repoService = ETLEntryPoint.getInstance().getRepoService();
		RepositoryProvider repoProvider = ETLEntryPoint.getInstance().getRepoService().getRepositoryProvider();
		if ( promote == Promote.PUBLISH ) {
			repoProvider.transition( repoService.getSession(), Arrays.asList( resource ), RepoService.SENT_TO_CURATION_TRANSITION );
			repoProvider.claim( repoService.getSession(), Arrays.asList( resource ) );
			repoProvider.transition( repoService.getSession(), Arrays.asList( resource ), RepoService.PUBLISH_TRANSITION );
			return true;
		} else if ( promote == Promote.CURATION ) {
			repoProvider.transition( repoService.getSession(), Arrays.asList( resource ), RepoService.DEFAULT_CREATE_TRANSITION );
			repoProvider.transition( repoService.getSession(), Arrays.asList( resource ), RepoService.SENT_TO_CURATION_TRANSITION );
			repoProvider.release( repoService.getSession(), Arrays.asList( resource ) );
			return true;
		} else if ( promote == Promote.DRAFT ) {
			repoProvider.release( repoService.getSession(), Arrays.asList( resource ) );
			return true;
		} else {
			return false;
		}

	}

}
