/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server.transformer;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.RepoService;
import org.eaglei.datatools.etl.server.transformer.EmbeddedExpression;
import org.eaglei.datatools.etl.server.transformer.Expression;
import org.eaglei.datatools.etl.server.transformer.MapInterpreterTracker;
import org.eaglei.datatools.etl.server.transformer.ObjectLiteralExpression;
import org.eaglei.datatools.etl.server.transformer.OntologyExpression;
import org.eaglei.datatools.etl.server.transformer.ResourceExpression;
import org.eaglei.datatools.model.AnnotationFormModel;

public class MapInterpreter
extends Expression<Statement[]> {
    private List<Expression> expressionList = new ArrayList<Expression>();
    private RepoService repoService;
    private Model mapModel;
    private static Logger logger = Logger.getLogger(MapInterpreter.class);
    public static final String PRIMARY_INSTANCE_EXPRESSION_MATCHER = "Ex:e+$NEW_INSTANCE";
    private String expressionString;
    private Statement expressionStatement;
    private AnnotationFormModel anntModel;
    Resource mainNodesubject;

    public MapInterpreter(Model mapModel, Map<String, String> columnMap, AnnotationFormModel anntModel, RepoService repoService) throws IOException {
        this.repoService = repoService;
        this.mapModel = mapModel;
        this.expressionString = PRIMARY_INSTANCE_EXPRESSION_MATCHER;
        this.anntModel = anntModel;
        this.expressionStatement = null;
        String base = repoService.getDatatoolsConfiguration().getDatatoolsRepositoryNamespace();
        this.evaluatePrimaryInstance(mapModel, columnMap);
    }

    public MapInterpreter(Model primaryMapModel, Model secondaryModel, Map<String, String> columnMap, String expressionString, Statement expressionStatement, AnnotationFormModel anntModel, RepoService repoService) throws IOException {
        this.repoService = repoService;
        this.mapModel = primaryMapModel;
        this.expressionString = expressionString;
        this.expressionStatement = expressionStatement;
        this.anntModel = anntModel;
        String base = repoService.getDatatoolsConfiguration().getDatatoolsRepositoryNamespace();
        this.evaluateSecondaryInstance(secondaryModel, columnMap);
    }

    private void evaluatePrimaryInstance(Model mapModel, Map<String, String> columnMap) {
        Model modelTocreateStatments = ModelFactory.createDefaultModel();
        this.mainNodesubject = this.repoService.getNewResourceFromRepository(modelTocreateStatments);
        MapInterpreter.putInMap(MapInterpreterTracker.getInstance().getMapOfExpressionStringToResourceURI(), PRIMARY_INSTANCE_EXPRESSION_MATCHER, this.mainNodesubject);
        StmtIterator subIter = mapModel.listStatements();
        while (subIter.hasNext()) {
            Statement stmtMap = subIter.nextStatement();
            Resource subjectMap = stmtMap.getSubject();
            RDFNode objectMap = stmtMap.getObject();
            Property property = stmtMap.getPredicate();
            Statement expToURIStatementMap = modelTocreateStatments.createStatement(this.mainNodesubject, property, objectMap);
            if (!subjectMap.getURI().equals(PRIMARY_INSTANCE_EXPRESSION_MATCHER)) continue;
            this.prepareExpressionStack(mapModel, columnMap, expToURIStatementMap, objectMap);
        }
    }

    private void evaluateSecondaryInstance(Model submapModel, Map<String, String> columnMap) {
        StmtIterator subIter = submapModel.listStatements();
        while (subIter.hasNext()) {
            Statement stmtMap = subIter.nextStatement();
            RDFNode objectMap = stmtMap.getObject();
            this.prepareExpressionStack(this.mapModel, columnMap, stmtMap, objectMap);
        }
    }

    private void prepareExpressionStack(Model mapModel, Map<String, String> columnMap, Statement stmtMap, RDFNode objectMap) {
        if (objectMap.toString().startsWith("Ex:e+$")) {
            ResourceExpression resourceExpression = new ResourceExpression(objectMap.toString(), columnMap, stmtMap, mapModel, this.anntModel, this.repoService);
            this.expressionList.add(resourceExpression);
        } else if (objectMap.toString().startsWith("Ex:$")) {
            ObjectLiteralExpression objectExpression = new ObjectLiteralExpression(objectMap.toString(), stmtMap, columnMap);
            this.expressionList.add(objectExpression);
        } else if (objectMap.toString().startsWith("Ex:ont+$")) {
            OntologyExpression ontologyExpression = new OntologyExpression(objectMap.toString(), stmtMap, mapModel, this.anntModel, columnMap, this.repoService);
            this.expressionList.add(ontologyExpression);
        } else if (objectMap.toString().startsWith("Ex:emb")) {
            EmbeddedExpression embeddedClassExpression = new EmbeddedExpression(objectMap.toString(), columnMap, stmtMap, mapModel, this.anntModel, this.repoService);
            this.expressionList.add(embeddedClassExpression);
        } else {
            PlainStatementExpression plainStatementExpression = new PlainStatementExpression(stmtMap);
            this.expressionList.add(plainStatementExpression);
        }
    }

    @Override
    public Statement[] interpret() {
        ArrayList<Statement> statementList = new ArrayList<Statement>();
        for (Expression expression : this.expressionList) {
            if (MapInterpreterTracker.getInstance().getMapOfExpressionStringToResourceURI().keySet().contains(expression.getExpressionString())) {
                Statement expressionStatement = expression.getExpressionStatement();
                List<Resource> lstResource = MapInterpreterTracker.getInstance().getMapOfExpressionStringToResourceURI().get(expression.getExpressionString());
                Model modelTocreateStatments = ModelFactory.createDefaultModel();
                for (Resource resource : lstResource) {
                    Statement newStatement = this.getExpressionStatement() == null ? modelTocreateStatments.createStatement(this.getMainSubject(), expressionStatement.getPredicate(), (RDFNode)resource) : modelTocreateStatments.createStatement((Resource)this.getExpressionStatement().getObject(), expressionStatement.getPredicate(), (RDFNode)resource);
                    statementList.add(newStatement);
                }
                continue;
            }
            Statement[] statementAry = (Statement[])expression.interpret();
            if (!(expression instanceof ObjectLiteralExpression || expression instanceof PlainStatementExpression || expression.getExpressionString().equals(PRIMARY_INSTANCE_EXPRESSION_MATCHER))) {
                for (Statement statement : statementAry) {
                    if (!statement.getPredicate().equals(expression.getExpressionStatement().getPredicate())) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("expression string " + expression.getExpressionString()));
                    }
                    MapInterpreter.putInMap(MapInterpreterTracker.getInstance().getMapOfExpressionStringToResourceURI(), expression.getExpressionString(), (Resource)statement.getObject());
                }
            }
            if (statementAry == null) continue;
            statementList.addAll(Arrays.asList(statementAry));
        }
        if (this.mainNodesubject != null) {
            return this.replaceMainNodeExpressionByMainNodeSubject(statementList);
        }
        return statementList.toArray(new Statement[statementList.size()]);
    }

    private Statement[] replaceMainNodeExpressionByMainNodeSubject(List<Statement> statementList) {
        Statement[] statementAryToReturn = new Statement[statementList.size()];
        int i = 0;
        for (Statement stmt : statementList) {
            Statement changedStatement;
            statementAryToReturn[i] = stmt.getObject().toString().equals(PRIMARY_INSTANCE_EXPRESSION_MATCHER) ? (changedStatement = stmt.changeObject((RDFNode)this.getMainSubject())) : stmt;
            ++i;
        }
        return statementAryToReturn;
    }

    public Resource getMainSubject() {
        return this.mainNodesubject;
    }

    @Override
    public String getExpressionString() {
        return this.expressionString;
    }

    @Override
    public Statement getExpressionStatement() {
        return this.expressionStatement;
    }

    private static void putInMap(Map<String, List<Resource>> mapInstanceExp, String key, Resource value) {
        List<Resource> strAry = mapInstanceExp.get(key);
        if (strAry != null) {
            strAry.add(value);
        } else {
            ArrayList<Resource> list = new ArrayList<Resource>();
            list.add(value);
            mapInstanceExp.put(key, list);
        }
    }

    class PlainStatementExpression
    extends Expression<Statement[]> {
        private Statement mapStatement;
        private Model mapModel;

        public PlainStatementExpression(Statement mapStatement) {
            this.mapStatement = mapStatement;
        }

        @Override
        public Statement[] interpret() {
            return new Statement[]{this.mapStatement};
        }

        @Override
        public String getExpressionString() {
            return this.mapStatement.getObject().toString();
        }

        @Override
        public Statement getExpressionStatement() {
            return this.mapStatement;
        }
    }
}

