/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.utils;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.utils.ETLUtils;
import org.eaglei.datatools.provider.RepositoryProvider;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.security.Session;
import org.eaglei.services.repository.RepositoryProviderException;

public class ETLSPARQLQueryUtil {
    private static Logger logger = Logger.getLogger(ETLSPARQLQueryUtil.class);

    public static String getEIResourcesByAllPropertiesQuery(RepositoryProvider provider, Model rdfModel, Session session) throws Exception {
        StringBuilder sparql = new StringBuilder();
        EIInstance instance = null;
        sparql.append("PREFIX rdf: <");
        sparql.append("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        sparql.append("> ");
        sparql.append("PREFIX rdfs: <");
        sparql.append("http://www.w3.org/2000/01/rdf-schema#");
        sparql.append("> ");
        sparql.append("SELECT ?resource WHERE {");
        String query = ETLSPARQLQueryUtil.getEIResourcesByOnlyTypeANDRdfsLabel(rdfModel);
        String result = provider.query(session, query);
        String[] resultAry = ETLSPARQLQueryUtil.getInstanceURI(result);
        try {
            if (resultAry.length > 0) {
                instance = provider.getOneInstance(session, EIURI.create((String)resultAry[0]), true);
            }
        }
        catch (RepositoryProviderException e) {
            logger.info((Object)"ITs an ontology instance");
            return query;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StmtIterator stmtIterator = rdfModel.listStatements();
        int i = 0;
        while (stmtIterator.hasNext()) {
            Statement stmtMap = stmtIterator.nextStatement();
            Property predicateMap = stmtMap.getPredicate();
            RDFNode objectMap = stmtMap.getObject();
            if (instance != null && (objectMap.isLiteral() ? instance.getNonOntologyLiteralProperties().toString().contains(predicateMap.toString()) || instance.getReadOnlyLiteralProperties().toString().contains(predicateMap.toString()) : instance.getNonOntologyResourceProperties().toString().contains(predicateMap.toString()) || instance.getReadOnlyResourceProperties().toString().contains(predicateMap.toString()))) continue;
            sparql.append("?resource <" + predicateMap.getURI() + "> ");
            if (objectMap.isResource()) {
                Resource objResource = (Resource)objectMap;
                sparql.append("\t <" + objResource.getURI() + "> . ");
            } else {
                sparql.append("?o" + i + " FILTER regex(str(?o" + i + "), \"^" + ETLUtils.forRegex(objectMap.toString()).split("\\^\\^")[0].replace("\"", "\\\"").trim() + "$\", \"i\").");
            }
            ++i;
        }
        sparql.append("}");
        return sparql.toString();
    }

    public static String getEIResourcesQueryButnotWithPassProperty(Model rdfModel, Property property) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("PREFIX rdf: <");
        sparql.append("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        sparql.append("> ");
        sparql.append("PREFIX rdfs: <");
        sparql.append("http://www.w3.org/2000/01/rdf-schema#");
        sparql.append("> ");
        sparql.append("SELECT ?resource WHERE {");
        StmtIterator stmtIterator = rdfModel.listStatements();
        int i = 0;
        while (stmtIterator.hasNext()) {
            Statement stmtMap = stmtIterator.nextStatement();
            Resource subjectMap = stmtMap.getSubject();
            Property predicateMap = stmtMap.getPredicate();
            RDFNode objectMap = stmtMap.getObject();
            if (predicateMap.toString().equals(property.toString())) continue;
            sparql.append("?resource <" + predicateMap.getURI() + "> ");
            if (objectMap.isResource()) {
                Resource objResource = (Resource)objectMap;
                sparql.append("\t <" + objResource.getURI() + "> . ");
            } else {
                sparql.append("?o" + i + " FILTER regex(str(?o" + i + "), \"^" + ETLUtils.forRegex(objectMap.toString()).split("\\^\\^")[0].replace("\"", "\\\"").trim() + "$\", \"i\").");
            }
            ++i;
        }
        sparql.append("}");
        return sparql.toString();
    }

    public static String getEIResourcesByOnlyTypeANDRdfsLabel(Model rdfModel) {
        StringBuilder sparql = new StringBuilder();
        sparql.append("PREFIX rdf: <");
        sparql.append("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        sparql.append("> ");
        sparql.append("PREFIX rdfs: <");
        sparql.append("http://www.w3.org/2000/01/rdf-schema#");
        sparql.append("> ");
        sparql.append("SELECT ?resource WHERE {");
        StmtIterator stmtIterator = rdfModel.listStatements();
        while (stmtIterator.hasNext()) {
            Statement stmtMap = stmtIterator.nextStatement();
            Property predicateMap = stmtMap.getPredicate();
            RDFNode objectMap = stmtMap.getObject();
            if (!predicateMap.getURI().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type") && !predicateMap.getURI().equals("http://www.w3.org/2000/01/rdf-schema#label")) continue;
            sparql.append("?resource <" + predicateMap.getURI() + "> ");
            if (objectMap.isResource()) {
                Resource objResource = (Resource)objectMap;
                sparql.append("\t <" + objResource.getURI() + "> . ");
                continue;
            }
            sparql.append("?o FILTER regex(str(?o), \"^" + ETLUtils.forRegex(objectMap.toString()).split("\\^\\^")[0].replace("\"", "\\\"") + "$\", \"i\").");
        }
        sparql.append("}");
        return sparql.toString();
    }

    public static String[] getInstanceURI(String xmlString) {
        if (xmlString != null) {
            Pattern instancePattern = Pattern.compile("<uri>([^<]*?)</uri>");
            Matcher match = instancePattern.matcher(xmlString);
            ArrayList<String> instanceList = new ArrayList<String>();
            while (match.find()) {
                int count = match.groupCount();
                for (int i = 1; i <= count; ++i) {
                    instanceList.add(match.group(i));
                }
            }
            return instanceList.toArray(new String[instanceList.size()]);
        }
        return null;
    }
}

