/**
 * 
 */
package org.eaglei.datatools.etl.server.transformer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.ETLEntryPoint;
import org.eaglei.datatools.etl.server.RepoService;
import org.eaglei.datatools.model.AnnotationFormModel;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;

/**
 * @author Sravan Kumar Cheriyala
 * 
 *         Design Pattern Used:Interpretor Design Pattern
 * 
 *         FIXME:write more documentation
 */
public class MapInterpreter extends Expression<Statement[]> {

	private List<Expression> expressionList = new ArrayList<Expression>();
	private RepoService repoService;
	private Model mapModel;
	private static org.apache.log4j.Logger logger = Logger.getLogger( MapInterpreter.class );
	public static final String PRIMARY_INSTANCE_EXPRESSION_MATCHER = "Ex:e+$NEW_INSTANCE";
	private String expressionString;
	private Statement expressionStatement;
	private AnnotationFormModel anntModel;
	Resource mainNodesubject;

	public MapInterpreter(Model mapModel, Map<String, String> columnMap, AnnotationFormModel anntModel, RepoService repoService) throws IOException {

		this.repoService = repoService;
		this.mapModel = mapModel;
		expressionString = PRIMARY_INSTANCE_EXPRESSION_MATCHER;
		this.anntModel = anntModel;
		expressionStatement = null;
		/* gets the base namespace from properties file */
		String base = repoService.getDatatoolsConfiguration().getDatatoolsRepositoryNamespace();
		// FIXME: re do expression engine
		// rdf123Exp = new Rdf123Expression( rowData, mapModel.getNsPrefixMap(), 1, base );
		evaluatePrimaryInstance( mapModel, columnMap );

	}

	// FIXME :toomany argumetns
	public MapInterpreter(Model primaryMapModel, Model secondaryModel, Map<String, String> columnMap, String expressionString, Statement expressionStatement, AnnotationFormModel anntModel, RepoService repoService) throws IOException {

		this.repoService = repoService;
		this.mapModel = primaryMapModel;
		this.expressionString = expressionString;
		this.expressionStatement = expressionStatement;
		this.anntModel = anntModel;
		/* gets the base namespace from properties file */
		String base = repoService.getDatatoolsConfiguration().getDatatoolsRepositoryNamespace();
		// rdf123Exp = new Rdf123Expression( rowData, mapModel.getNsPrefixMap(), 1, base );
		evaluateSecondaryInstance( secondaryModel, columnMap );

	}

	private void evaluatePrimaryInstance(Model mapModel, Map<String, String> columnMap) {

		/* loop through the primary instance of map and prepare expression stack */
		Model modelTocreateStatments = ModelFactory.createDefaultModel();
		mainNodesubject = repoService.getNewResourceFromRepository( modelTocreateStatments );
		putInMap( MapInterpreterTracker.getInstance().getMapOfExpressionStringToResourceURI(), PRIMARY_INSTANCE_EXPRESSION_MATCHER, mainNodesubject );

		StmtIterator subIter = mapModel.listStatements();
		while ( subIter.hasNext() ) {
			Statement stmtMap = subIter.nextStatement();
			Resource subjectMap = stmtMap.getSubject();
			RDFNode objectMap = stmtMap.getObject();
			Property property = stmtMap.getPredicate();
			/* replace Ex:e+$0 with new instance URI */
			Statement expToURIStatementMap = modelTocreateStatments.createStatement( mainNodesubject, property, objectMap );
			/*
			 * if the statement is primary node statement then add that statement to the stack
			 */
			if ( subjectMap.getURI().equals( ResourceExpression.RESOURCE_EXPRESSION_MATCHER + "NEW_INSTANCE" ) ) {
				prepareExpressionStack( mapModel, columnMap, expToURIStatementMap, objectMap );
			}

		}
	}

	private void evaluateSecondaryInstance(Model submapModel, Map<String, String> columnMap) {
		/*
		 * loop through the secondary instance of map and prepare expression stack
		 */
		StmtIterator subIter = submapModel.listStatements();
		while ( subIter.hasNext() ) {
			Statement stmtMap = subIter.nextStatement();
			RDFNode objectMap = stmtMap.getObject();
			prepareExpressionStack( mapModel, columnMap, stmtMap, objectMap );

		}
	}

	private void prepareExpressionStack(Model mapModel, Map<String, String> columnMap, Statement stmtMap, RDFNode objectMap) {

		if ( objectMap.toString().startsWith( ResourceExpression.RESOURCE_EXPRESSION_MATCHER ) ) {
			Expression<Statement[]> resourceExpression = new ResourceExpression( objectMap.toString(), columnMap, stmtMap, mapModel, anntModel, repoService );
			expressionList.add( resourceExpression );
		} else if ( objectMap.toString().startsWith( ObjectLiteralExpression.OBJECT_LITERAL_EXPRESSION_MATCHER ) ) {
			Expression<Statement[]> objectExpression = new ObjectLiteralExpression( objectMap.toString(), stmtMap, columnMap );
			expressionList.add( objectExpression );
		} else if ( objectMap.toString().startsWith( OntologyExpression.ONTOLOGY_EXPRESSION_MATCHER ) ) {
			Expression<Statement[]> ontologyExpression = new OntologyExpression( objectMap.toString(), stmtMap, mapModel, anntModel, columnMap, repoService );
			expressionList.add( ontologyExpression );
		}// else if ( objectMap.toString().startsWith( ResourceOntologyExpression.RESOURCE_ONTOLOGY_EXPRESSION_MATCHER ) ) {
		// Expression<Statement[]> resourceOntologyExpresion = new ResourceOntologyExpression( objectMap.toString(), tabData, stmtMap, mapModel );
		// expressionList.add( resourceOntologyExpresion );
		// }
		else if ( objectMap.toString().startsWith( EmbeddedExpression.EMBEDDED_CLASS_EXPRESSION_MATCHER ) ) {
			Expression<Statement[]> embeddedClassExpression = new EmbeddedExpression( objectMap.toString(), columnMap, stmtMap, mapModel, anntModel, this.repoService );
			expressionList.add( embeddedClassExpression );
		} else {
			Expression<Statement[]> plainStatementExpression = new PlainStatementExpression( stmtMap );
			expressionList.add( plainStatementExpression );
		}
	}

	@Override
	public Statement[] interpret() {
		ArrayList<Statement> statementList = new ArrayList<Statement>();
		/* loop through expression stack and interpret that expression */
		for (Expression<Statement[]> expression : expressionList) {
			if ( MapInterpreterTracker.getInstance().getMapOfExpressionStringToResourceURI().keySet().contains( expression.getExpressionString() ) ) {
				Statement expressionStatement = expression.getExpressionStatement();
				List<Resource> lstResource = MapInterpreterTracker.getInstance().getMapOfExpressionStringToResourceURI().get( expression.getExpressionString() );
				Model modelTocreateStatments = ModelFactory.createDefaultModel();
				for (Resource resource : lstResource) {
					Statement newStatement;
					if ( this.getExpressionStatement() == null ) {
						newStatement = modelTocreateStatments.createStatement( this.getMainSubject(), expressionStatement.getPredicate(), (Resource)resource );
					} else {
						newStatement = modelTocreateStatments.createStatement( (Resource)this.getExpressionStatement().getObject(), expressionStatement.getPredicate(), (Resource)resource );
					}

					statementList.add( newStatement );
				}
				continue;
			}

			Statement[] statementAry = expression.interpret();

			if ( !( expression instanceof ObjectLiteralExpression ) && !( expression instanceof PlainStatementExpression ) && !expression.getExpressionString().equals( MapInterpreter.PRIMARY_INSTANCE_EXPRESSION_MATCHER ) ) {
				for (Statement statement : statementAry) {
					if ( statement.getPredicate().equals( expression.getExpressionStatement().getPredicate() ) ) {
						if ( logger.isDebugEnabled() )
							logger.debug( "expression string " + expression.getExpressionString() );
						putInMap( MapInterpreterTracker.getInstance().getMapOfExpressionStringToResourceURI(), expression.getExpressionString(), (Resource)statement.getObject() );
					}
				}
			}
			if ( statementAry == null ) {
				continue;
			}
			/*
			 * add the statement array to statement list which will be returned
			 */
			statementList.addAll( Arrays.asList( statementAry ) );

		}
		if ( mainNodesubject != null ) {
			return replaceMainNodeExpressionByMainNodeSubject( statementList );
		} else {
			return statementList.toArray( new Statement[statementList.size()] );
		}

	}

	private Statement[] replaceMainNodeExpressionByMainNodeSubject(List<Statement> statementList) {
		Statement[] statementAryToReturn = new Statement[statementList.size()];
		int i = 0;
		for (Statement stmt : statementList) {
			if ( stmt.getObject().toString().equals( MapInterpreter.PRIMARY_INSTANCE_EXPRESSION_MATCHER ) ) {
				Statement changedStatement = stmt.changeObject( this.getMainSubject() );
				statementAryToReturn[i] = changedStatement;
			} else {
				statementAryToReturn[i] = stmt;
			}

			i++;
		}
		return statementAryToReturn;
	}

	public Resource getMainSubject() {
		return mainNodesubject;
	}

	class PlainStatementExpression extends Expression<Statement[]> {

		private Statement mapStatement;
		private Model mapModel;

		public PlainStatementExpression(Statement mapStatement) {
			this.mapStatement = mapStatement;
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eaglei.datatools.etl.server.Expression#interpret(int)
		 */
		@Override
		public Statement[] interpret() {
			return new Statement[] { mapStatement };
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eaglei.datatools.etl.server.Expression#getExpressionString()
		 */
		@Override
		public String getExpressionString() {
			// TODO Auto-generated method stub
			return mapStatement.getObject().toString();
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eaglei.datatools.etl.server.Expression#getSubjectResourceOfExpression()
		 */
		@Override
		public Statement getExpressionStatement() {
			// TODO Auto-generated method stub
			return mapStatement;
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.etl.server.Expression#getExpressionString()
	 */
	@Override
	public String getExpressionString() {

		return expressionString;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eaglei.datatools.etl.server.Expression#getSubjectResourceOfExpression()
	 */
	@Override
	public Statement getExpressionStatement() {

		return expressionStatement;
	}

	private static void putInMap(Map<String, List<Resource>> mapInstanceExp, String key, Resource value) {
		List<Resource> strAry = mapInstanceExp.get( key );
		if ( strAry != null ) {
			strAry.add( value );
		} else {
			List<Resource> list = new ArrayList<Resource>();
			list.add( value );
			mapInstanceExp.put( key, list );
		}
	}

}
