/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server.transformer;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.RepoService;
import org.eaglei.datatools.etl.server.transformer.Expression;
import org.eaglei.datatools.etl.server.transformer.SemiColonExpresson;
import org.eaglei.datatools.etl.utils.ETLUtils;
import org.eaglei.datatools.model.AnnotationFormModel;

public class OntologyExpression
extends Expression<Statement[]> {
    public static final String ONTOLOGY_EXPRESSION_MATCHER = "Ex:ont+$";
    private String ontologyExpression;
    private Map<String, String> columnMap;
    private Statement mapStatement;
    private Model mapModel;
    private AnnotationFormModel anntModel;
    private RepoService repoService;
    private static Logger logger = Logger.getLogger(OntologyExpression.class);

    public OntologyExpression(String ontologyExpression, Statement mapStatement, Model mapModel, AnnotationFormModel anntModel, Map<String, String> columnMap, RepoService repoService) {
        this.ontologyExpression = ontologyExpression;
        this.mapStatement = mapStatement;
        this.mapModel = mapModel;
        this.repoService = repoService;
        this.anntModel = anntModel;
        this.columnMap = columnMap;
    }

    @Override
    public Statement[] interpret() {
        Model subNodeMapModel = ETLUtils.getsubModelByExpression(this.ontologyExpression, this.mapModel);
        SemiColonExpresson semiColonExpression = new SemiColonExpresson(subNodeMapModel, this.columnMap);
        Model[] modelAfterSemiColonInterpretation = semiColonExpression.interpret();
        ArrayList<Statement> statementList = new ArrayList<Statement>();
        for (Model model : modelAfterSemiColonInterpretation) {
            Statement[] statementAry = this.interpretOntologyExpressionAfterSemicolon(model);
            if (statementAry == null) continue;
            statementList.addAll(Arrays.asList(statementAry));
        }
        return statementList.toArray(new Statement[statementList.size()]);
    }

    private Statement[] interpretOntologyExpressionAfterSemicolon(Model subNodeMapModel) {
        try {
            String[] strAry = ETLUtils.getLabelAndRootURI(subNodeMapModel, this.columnMap);
            String strLabel = strAry[0];
            if (strLabel != null && !strLabel.equals("")) {
                String instanceURI;
                if (strLabel.equalsIgnoreCase("Protocol")) {
                    strLabel = "Technique";
                }
                if (strLabel.equalsIgnoreCase("core facility")) {
                    strLabel = "Core Laboratory";
                }
                if (strLabel.equalsIgnoreCase("research facility")) {
                    strLabel = "Laboratory";
                }
                if (strLabel.equalsIgnoreCase("laboratory")) {
                    strLabel = "Laboratory";
                }
                if ((instanceURI = this.checkOntology(strLabel.toLowerCase(), strAry[1])) == null) {
                    return this.getStatementsWhenTermsNotFound(subNodeMapModel, strAry[1], strAry[0]);
                }
                Resource foundTermObject = subNodeMapModel.createResource(instanceURI);
                Statement statementToReturn = this.mapStatement.changeObject((RDFNode)foundTermObject);
                return new Statement[]{statementToReturn};
            }
            return new Statement[0];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Statement[] getStatementsWhenTermsNotFound(Model subNodeMapModel, String instanceURI, String termLabel) {
        Resource typeObject = subNodeMapModel.createResource(instanceURI);
        Statement parentStatement = this.mapStatement.changeObject((RDFNode)typeObject);
        Property termNotFoundProperty = subNodeMapModel.createProperty("http://eagle-i.org/ont/datatools/1.0/temp_term_not_found");
        Statement unFoundTermStatement = subNodeMapModel.createStatement(this.mapStatement.getSubject(), termNotFoundProperty, termLabel);
        return new Statement[]{parentStatement, unFoundTermStatement};
    }

    private String checkOntology(String label, String URI) throws Exception {
        String result = null;
        if (label != null) {
            result = this.anntModel.findSubclassByLabel(URI, label.replace("  ", " ").trim());
        }
        if (result == null) {
            return URI;
        }
        return result;
    }

    @Override
    public String getExpressionString() {
        return this.ontologyExpression;
    }

    @Override
    public Statement getExpressionStatement() {
        return this.mapStatement;
    }
}

