/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.interim.cores;

import com.hp.hpl.jena.ontology.OntModel;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.interim.cores.Cores3RDFGenerator;
import org.eaglei.datatools.interim.cores.OldFileUtils;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class Cores3BatchRDFGenerator {
    private static final Log logger = LogFactory.getLog(Cores3BatchRDFGenerator.class);

    public static void main(String[] args) throws Exception {
        if (args.length <= 1 || args[0].length() == 0 || args[1].length() == 0) {
            logger.error((Object)"Cores3Batch RDFGenerator <input dir> <output dir> [RDF/XML | N-TRIPLE]");
            return;
        }
        String format = "RDF/XML";
        if (args.length > 2 && args[2] != null && args[2].length() > 0) {
            if (!"RDF/XML".equals(args[2]) && !"N-TRIPLE".equals(args[2])) {
                logger.error((Object)("Unsupported format: " + args[2]));
            } else {
                format = args[2];
            }
        }
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{"datatools-model-config.xml"});
        OntModel datatoolsJenaOntModel = (OntModel)context.getBean("datatoolsJenaOntModel", OntModel.class);
        Cores3BatchRDFGenerator.generate(args[0], args[1], format, datatoolsJenaOntModel);
    }

    private static void generate(String inputPath, String outputPath, String format, OntModel datatoolsJenaOntModel) throws IOException {
        File inputDir = new File(inputPath);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Reading Excel data from directory: " + inputDir.getAbsolutePath()));
        }
        OldFileUtils.validateDirectory(inputDir, false);
        List<File> files = OldFileUtils.getAllFiles(inputDir);
        for (File file : files) {
            String excelFile = file.getAbsolutePath();
            Cores3RDFGenerator.generateToFile(excelFile, outputPath, format, datatoolsJenaOntModel);
        }
    }
}

