/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.etl.server.transformer;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eaglei.datatools.etl.server.transformer.Expression;
import org.eaglei.datatools.etl.utils.ETLUtils;

class ObjectLiteralExpression
extends Expression<Statement[]> {
    private String literalExpression;
    private Map<String, String> columnMap;
    private Statement mapStatement;
    public static final String OBJECT_LITERAL_EXPRESSION_MATCHER = "Ex:$";
    private static Logger logger = Logger.getLogger(ObjectLiteralExpression.class);

    public ObjectLiteralExpression(String literalExpression, Statement mapStatement, Map<String, String> columnMap) {
        this.literalExpression = literalExpression;
        this.columnMap = columnMap;
        this.mapStatement = mapStatement;
    }

    @Override
    public Statement[] interpret() {
        try {
            String result = ETLUtils.evaluateExpression(this.columnMap, this.literalExpression.toString());
            if (result == null || result.equals("")) {
                return null;
            }
            Model m = ModelFactory.createDefaultModel();
            String[] stringAry = result.split(";");
            Statement[] statementAry = new Statement[stringAry.length];
            int i = 0;
            for (String resultStr : stringAry) {
                Resource object = m.createResource(resultStr);
                Statement stmt = resultStr.startsWith("http://") ? m.createStatement(this.mapStatement.getSubject(), this.mapStatement.getPredicate(), (RDFNode)object) : m.createStatement(this.mapStatement.getSubject(), this.mapStatement.getPredicate(), resultStr);
                statementAry[i] = stmt;
                ++i;
            }
            return statementAry;
        }
        catch (Exception e) {
            logger.error((Object)"Exception has raised in ObjectLiteralExpression's interpret method");
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getExpressionString() {
        return this.literalExpression;
    }

    @Override
    public Statement getExpressionStatement() {
        return this.mapStatement;
    }
}

