/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.interim.gsites;

import com.google.gdata.util.ServiceException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.interim.gsites.GSitesUtils;

public class UploadAttachments {
    private static final Log logger = LogFactory.getLog(UploadAttachments.class);

    public static void main(String[] args) throws IOException, ServiceException {
        if (args.length < 1 || args[0].length() == 0) {
            logger.error((Object)"UploadAttachments <base input path> [rnav]");
            return;
        }
        if (args.length == 1) {
            UploadAttachments.uploadForAll(args[0]);
        } else {
            UploadAttachments.uploadForRnav(args[1], args[0]);
        }
        logger.debug((Object)"Done!");
    }

    private static void uploadForAll(String path) throws IOException, ServiceException {
        GSitesUtils.login();
        GSitesUtils.setAttachments(path);
    }

    private static void uploadForRnav(String path, String rnav) throws IOException, ServiceException {
        GSitesUtils.login();
        GSitesUtils.setAttachmentsForRnav(path, rnav);
    }
}

