/**
 * eagle-i Project
 * Harvard University
 * Feb 15, 2010
 */
package org.eaglei.datatools.interim.gsites;

import java.io.IOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.google.gdata.util.ServiceException;

/**
 * @author dbw
 *
 */
public class UploadAttachments {
	private static final Log logger = LogFactory
		.getLog(UploadAttachments.class);
	
	/**
	 * @param args base input path
	 * @throws ServiceException 
	 * @throws IOException 
	 */
	public static void main(String[] args) throws IOException, ServiceException {

        if (args.length < 1 || args[0].length() == 0) {
            logger.error("UploadAttachments <base input path> [rnav]");
            return;
        }
        if(args.length == 1)
        	uploadForAll(args[0]);
        else
        	uploadForRnav(args[1], args[0]);
        	
        logger.debug("Done!");
	}
	
    private static void uploadForAll(String path) throws IOException, ServiceException {
    		GSitesUtils.login();
    		GSitesUtils.setAttachments(path);	
        }
    
    private static void uploadForRnav(String path, String rnav) throws IOException, ServiceException {
    		GSitesUtils.login();
    		GSitesUtils.setAttachmentsForRnav(path, rnav);	
    }



}
