/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.interim.gsites;

import com.google.gdata.util.ServiceException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.interim.gsites.GSitesUtils;

public class DownloadAttachments {
    private static final Log logger = LogFactory.getLog(DownloadAttachments.class);

    public static void main(String[] args) throws IOException, ServiceException {
        if (args.length < 1 || args[0].length() == 0) {
            logger.error((Object)"DownloadAttachments <base output path> [mode]");
            return;
        }
        if (args.length > 1) {
            DownloadAttachments.download(args[0], args[1]);
        } else {
            DownloadAttachments.download(args[0], null);
        }
        logger.debug((Object)"Done!");
    }

    private static void download(String path, String mode) throws IOException, ServiceException {
        GSitesUtils.login();
        boolean delete = false;
        if (mode != null && "delete".equals(mode)) {
            delete = true;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Mode is set to delete");
            }
        }
        GSitesUtils.getAttachments(path, delete);
    }
}

