/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.model;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.datatools.model.DataToolsEIOntModel;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIURI;

public class AnnotationFormModel {
    private static final Log logger = LogFactory.getLog(AnnotationFormModel.class);
    private final DataToolsEIOntModel datatoolsEIOntModel;

    public AnnotationFormModel(DataToolsEIOntModel datatoolsEIOntModel) {
        this.datatoolsEIOntModel = datatoolsEIOntModel;
    }

    public String findSubclassByLabel(String rootURI, String subclassLabel) {
        EIURI rootEIURI;
        EIClass rootClass;
        if (rootURI == null || rootURI.length() == 0 || subclassLabel == null || subclassLabel.length() == 0) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Searching for a subclass of: " + rootURI + " with label: " + subclassLabel));
        }
        if ((rootClass = this.datatoolsEIOntModel.getClass(rootEIURI = EIURI.create((String)rootURI))) == null) {
            return null;
        }
        if (subclassLabel.equals(rootClass.getEntity().getLabel())) {
            return rootClass.getEntity().getURI().toString();
        }
        EIClass subclass = this.findSubclassByLabel(rootEIURI, subclassLabel);
        if (subclass == null) {
            return null;
        }
        return subclass.getEntity().getURI().toString();
    }

    private EIClass findSubclassByLabel(EIURI rootclassUri, String subclassLabel) {
        if (subclassLabel == null) {
            return null;
        }
        List<EIClass> subclasses = this.datatoolsEIOntModel.getSubClasses(rootclassUri);
        EIClass foundSubclass = null;
        for (EIClass subclass : subclasses) {
            if (subclassLabel.trim().equalsIgnoreCase(subclass.getEntity().getLabel())) {
                foundSubclass = subclass;
                break;
            }
            foundSubclass = this.findSubclassByLabel(subclass.getEntity().getURI(), subclassLabel);
            if (foundSubclass == null) continue;
            break;
        }
        return foundSubclass;
    }
}

