/**
 * eagle-i Project
 * Harvard University
 * Jan 27, 2010
 */
package org.eaglei.datatools.model;


import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIURI;


/**
 * @author Daniela Bourges-Waldegg
 *
 * Utilities to query the eagle-i ontology based on labels (for ETL)
 * This class uses DataToolsEIOntModel so that we get the same view on the eagle-i ontology as the webtool and search
 */

public class AnnotationFormModel {
	private static final Log logger = LogFactory.getLog(AnnotationFormModel.class);
	private final EIOntModel datatoolsEIOntModel;
	
	public AnnotationFormModel(EIOntModel datatoolsEIOntModel) {
	    this.datatoolsEIOntModel = datatoolsEIOntModel;
	}

	public  String findSubclassByLabel(final String rootURI, final String subclassLabel) {
		if(rootURI == null || rootURI.length() == 0 || subclassLabel == null || subclassLabel.length() == 0)
			return null;
		if(logger.isDebugEnabled())logger.debug("Searching for a subclass of: " + rootURI + " with label: " + subclassLabel);
		EIURI rootEIURI = EIURI.create(rootURI);
		EIClass rootClass = datatoolsEIOntModel.getClass(rootEIURI);
		if (rootClass == null)
			return null;
		if (subclassLabel.equals(rootClass.getEntity().getLabel()))
			return rootClass.getEntity().getURI().toString();
		EIClass subclass = findSubclassByLabel(rootEIURI, subclassLabel);
		if (subclass == null)
			return null;
		return subclass.getEntity().getURI().toString();
	}

	private EIClass findSubclassByLabel(final EIURI rootclassUri, final String subclassLabel){
		if (subclassLabel == null)
			return null;
		final List<EIClass> subclasses = datatoolsEIOntModel.getSubClasses(rootclassUri);
		EIClass foundSubclass = null;
		for(EIClass subclass : subclasses) {
			if(subclassLabel.trim().equalsIgnoreCase(subclass.getEntity().getLabel())) {
				foundSubclass = subclass;
				break;
			} else {
				 foundSubclass = findSubclassByLabel(subclass.getEntity().getURI(), subclassLabel);
				 if (foundSubclass != null)
					 break;
			}
		}	
		return foundSubclass;
	}
	
	


/*	private void materializeTypes(Resource resourceInstance, OntClass ontClass) {
        // get all of the parent classes
        final ExtendedIterator extIt = ontClass.listSuperClasses();
        while (extIt.hasNext()) {
            OntClass parent = (OntClass) extIt.next();
            if (parent.getURI() == null) {
                // Some reasoners return resources with null
                // URIs in the superclass list
                continue;
            }
            // don't add Thing
            if (parent.getURI().equals(OWL.Thing.getURI())) {
                continue;
            }
            if (parent.getURI().equals(RDFS.Resource.getURI())) {
                // Some reasoners return RDFS.Resource in superclass list.
                continue;
            }
            model.add(model.createStatement(resourceInstance, RDF.type, parent));
        }

	}
*/	

}