package org.eaglei.datatools.model;

import java.util.Deque;
import java.util.List;
import java.util.Set;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIEquivalentClass;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;

/**
 * Stores EIOntModel instance in a static for convenient access.
 */
public class DataToolsOntModelUtils {
    
    private static EIOntModelWrapper INSTANCE;
    
    /**
     * Get a reference to the EIOntModel.
     *
     * @return
     */
    public static EIOntModel getEIOntModel() {
        return INSTANCE;
    }
    
    /**
     * Override of getClass() method to check for invalid URI.
     */
    public static class EIOntModelWrapper implements EIOntModel {
        private final EIOntModel eagleiOntModel;
        
        public EIOntModelWrapper(EIOntModel eagleiOntModel)
        {
            this.eagleiOntModel = eagleiOntModel;
            INSTANCE = this;
        }

        @Override
        public String generateStackTrace(Deque<String> stack) {
            return eagleiOntModel.generateStackTrace(stack);
        }

        @Override
        public EIClass getClass(EIURI classId) {
            if (! isModelClassURI(classId.toString()))
                return null;
            return eagleiOntModel.getClass(classId);
        }

        @Override
        public String getClassDefinition(EIURI uri) {
            return eagleiOntModel.getClassDefinition(uri);
        }

        @Override
        public List<String> getClassDefinitions(List<EIURI> classURIs) {
            return eagleiOntModel.getClassDefinitions(classURIs);
        }

        @Override
        public List<String> getLabels(EIURI uri) {
            return eagleiOntModel.getLabels(uri);
        }

        @Override
        public List<EIClass> getNonResourceBaseClasses() {
            return eagleiOntModel.getNonResourceBaseClasses();
        }

        @Override
        public String getPreferredLabel(EIURI uri) {
            return eagleiOntModel.getPreferredLabel(uri);
        }

        @Override
        public List<EIEquivalentClass> getEquivalentClasses(EIURI classId) {
            return eagleiOntModel.getEquivalentClasses(classId);
        }
        
        @Override
        public List<EIProperty> getProperties(EIURI classId) {
            return eagleiOntModel.getProperties(classId);
        }
        
        @Override
        public String getPropertyDefinition(EIURI uri) {
            return eagleiOntModel.getPropertyDefinition(uri);
        }

        @Override
        public List<String> getPropertyDefinitions(List<EIURI> propertyURIs) {
            return eagleiOntModel.getPropertyDefinitions(propertyURIs);
        }

        @Override
        public List<EIClass> getSubClasses(EIURI classId) {
            return eagleiOntModel.getSubClasses(classId);
        }

        @Override
        public boolean isSubClass(EIURI ancestorURI, EIURI descendentURI) {
            return eagleiOntModel.isSubClass(ancestorURI, descendentURI);
        }

        @Override
        public EIClass getSuperClass(EIClass childClass) {
            return eagleiOntModel.getSuperClass(childClass);
        }

        @Override
        public List<EIClass> getTopLevelClasses() {
            return eagleiOntModel.getTopLevelClasses();
        }

        @Override
        public String getVersion() {
            return eagleiOntModel.getVersion();
        }

        @Override
        public boolean isModelClassURI(String uri) {
            return eagleiOntModel.isModelClassURI(uri);
        }

        @Override
        public void traverseDataModel(List<Visitor> visitors) {
            eagleiOntModel.traverseDataModel(visitors);
        }

        @Override
        public List<EIClass> getSuperClasses(EIURI classId) {
            return eagleiOntModel.getSuperClasses(classId);
        }

		@Override
		public List<Set<String>> getClassAnnotations(List<EIURI> classURIs) {
			return eagleiOntModel.getClassAnnotations(classURIs);
		}        
    }

}
