#
# Copyright (c) 2015, President and Fellows of Harvard College
# Portions Copyright (c) 2015, VectorC, LLC
# Portions Copyright (c) 2015, Wonder Lake Software, LLC
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# 3. The name of the author may not be used to endorse or promote products
# derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
# EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
# TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

import sys
import pycurl
import urllib
from repoUtils import getUPass, RepoCurler

class Promoter:
    def __init__(self, repoUrl, queryType, newState, user, password):
        self.repoUrl = repoUrl 
        self.user = user
        self.password = password
        self.curler = RepoCurler(self.repoUrl, self.user, self.password)
        
        
        # map short names to new state
        self.stateMap = {'curation':'http://eagle-i.org/ont/repo/1.0/WFS_Curation',
                         'http://eagle-i.org/ont/repo/1.0/WFS_Curation':'http://eagle-i.org/ont/repo/1.0/WFS_Curation',
                         'publish':'http://eagle-i.org/ont/repo/1.0/WFS_Published',
                         'http://eagle-i.org/ont/repo/1.0/WFS_Published':'http://eagle-i.org/ont/repo/1.0/WFS_Published',
                         'withdraw':'http://eagle-i.org/ont/repo/1.0/WFS_Withdrawn',
                         'http://eagle-i.org/ont/repo/1.0/WFS_Withdrawn':'http://eagle-i.org/ont/repo/1.0/WFS_Withdrawn',
                         'delete':'delete'}
        
        self.actionMap = {'ct':'ERO_0000015',
                          'ERO_0000015':'ERO_0000015',
                          'reagents':'ERO_0000006',
                          'reagent':'ERO_0000006',
                          'ERO_0000006':'ERO_0000006',
                          'construct':'ERO_0000285',
                          'ERO_0000285':'ERO_0000285',
                          'insert':'ERO_0000404',
                          'ERO_0000404':'ERO_0000404',
                          'all':'http://eagle-i.org/ont/repo/1.0/MatchAnything',
                          'stubs':'stubs'}
        
        self.resourceType = self.actionMap[queryType]
        print self.resourceType
        
        self.newState = self.stateMap[newState.lower()]
        print self.newState
        
        if queryType == 'all':
            self.urlquery = 'select ?s WHERE {?s <http://eagle-i.org/ont/repo/1.0/hasWorkflowState> <http://eagle-i.org/ont/repo/1.0/WFS_Curation> .}'
        elif queryType == 'stubs':
            self.urlquery = 'SELECT ?s WHERE { ?s <http://eagle-i.org/ont/datatools/1.0/is_stub> "True" }'
        else:
            self.urlquery = 'select ?s where {?s a <http://purl.obolibrary.org/obo/' + self.resourceType + '> .}'
    
    def getUris(self):
        formcontents = [('format', 'text/plain'),
                        ('view', 'user'),
                        ('query', self.urlquery)]
                        #('query', 'select ?s where {?s a <http://purl.obolibrary.org/obo/' + self.resourceType + '> .}')]
        
        self.curler.makeNewRequest("/sparql")

        self.curler.setopt(pycurl.HTTPPOST, formcontents)
    
        try:
            content = self.curler.getResult()
        except:
            content = 'error doing curl!'
        
        content = content.split('\n')
        
        uris = []
        for line in content:
            line = line.rstrip()
            if not line.startswith('s') and len(line) > 0:
                uris.append(line)
        
        print uris
        return uris
    
    def promoteAll(self):
        uris = self.getUris()
        
        if self.newState == 'delete':
            for uri in uris:
                self.delete(uri)
        else:
            for uri in uris:
                self.promote(uri)
            
    
    def promote(self, uri):
        print 'promoting ' + uri + ' to ' + self.newState
        
        postfields = 'promote='+self.newState+'&uri='+uri
        
        #print postfields
                
        self.curler.makeNewRequest("/fakeworkflow")
        self.curler.setopt(pycurl.POSTFIELDS, postfields)
        
        
        result = self.curler.getResult()
        print result
        
        print self.curler.getinfo(pycurl.HTTP_CODE)
 
    def delete(self, uri):
        print 'deleting ' + uri + '\n'
        self.curler.makeNewRequest('/update')
        self.curler.setopt(pycurl.HTTPPOST, [('action','gettoken'), ('format','text/plain'), ('uri',uri)])
        tokenplus = self.curler.getResult()
        
        token = tokenplus.split('\n')[1].split()[0]
        
        self.curler.makeNewRequest('/update')
        self.curler.setopt(pycurl.HTTPPOST, [('action','update'), ('format','text/plain'), ('uri',uri), ('token', token),
                                        ('delete', '<' + uri + '> <http://eagle-i.org/ont/repo/1.0/MatchAnything> <http://eagle-i.org/ont/repo/1.0/MatchAnything> .')])
        result = self.curler.getResult()
        print result
    
def main():
    if len(sys.argv) != 6:
        print "Takes 5 arguments: repository URL, [indicator of type], new state name or url, user name, and password"
    promoter = Promoter(sys.argv[1], sys.argv[2], sys.argv[3], sys.argv[4], sys.argv[5])
    promoter.promoteAll()

if __name__ == '__main__':
    main()
        