#
# Copyright (c) 2015, President and Fellows of Harvard College
# Portions Copyright (c) 2015, VectorC, LLC
# Portions Copyright (c) 2015, Wonder Lake Software, LLC
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
#
# 3. The name of the author may not be used to endorse or promote products
# derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
# EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
# TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

import sys
import pycurl
import StringIO

def getUPass(user, password):
    return user + ":" + password         

class RepoCurler:
    def __init__(self, repoUrl, user, password):
        self.curler = pycurl.Curl()
        self.repoUrl = repoUrl
        self.user = user
        self.password = password
        self.curler.setopt(pycurl.USERPWD, getUPass(self.user, self.password))
        self.performed = False
        
    def makeNewRequest(self, repoUrlSuffix, format = None):
        self.performed = False
        self.curler.setopt(pycurl.URL, self.repoUrl + repoUrlSuffix)
        
        self.b = StringIO.StringIO()
        self.curler.setopt(pycurl.WRITEFUNCTION, self.b.write)
        self.curler.setopt(pycurl.POST, 1)
        self.curler.setopt(pycurl.HTTPHEADER, ["Accept:"])
        
        if format is None:
            self.curler.setopt(pycurl.POSTFIELDS, "format=text/plain")
        else:
            self.curler.setopt(pycurl.POSTFIELDS, format)
        
    def setopt(self, optname, optval):
        self.curler.setopt(optname, optval)
        
    def perform(self):
        self.curler.perform()
        self.performed = True
        
    def getResult(self):
        if not self.performed:
            self.perform()
            
        return self.b.getvalue()
    
    def getinfo(self, field):
        return self.curler.getinfo(field)
        