/**
 * The eagle-i consortium
 * Harvard University
 * Apr 25, 2010
 */
package org.eaglei.datatools.etl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.eaglei.datatools.excel.ExcelUtils;
import org.eaglei.datatools.interim.cores.Mapping;

import static org.eaglei.datatools.interim.cores.Cores3Mappings.*;

/**
 * @author Daniela Bourges-Waldegg
 *
 */
public class Cores3ExcelParser {
	//I hate inner classes
	private List<ProcessedTab> processedTabs = new ArrayList<ProcessedTab>();
	
	public  Cores3ExcelParser(String fileName) throws ConfigurationException {
		Workbook wb = ExcelUtils.openWorkBook(fileName);
		Map<String,Mapping> configMap = MappingsFactory.createMappings("Cores3").getMappings();
		//TODO validate file version		
		int n = wb.getNumberOfSheets();
	//	for(int i=0; i < n; ++i) {
			final Sheet sheet = wb.getSheetAt(0);
		//	final String tabName = sheet.getSheetName().trim().replaceAll("\\s{1,}", "_").replaceAll("\\W{1,}", "");
			
			if(FIRST_ROWS.get("INSTRUMENT") != null) {
				final int firstRow = FIRST_ROWS.get("INSTRUMENT");
				final Mapping classMapping = configMap.get("INSTRUMENT");
				List<Map<String, String>> list = ExcelUtils.processTab(sheet,sheet.getLastRowNum());
				processedTabs.add(new ProcessedTab(classMapping, list));
			}
			/*
			if(FIRST_ROWS.get(tabName) != null) {
				final int firstRow = FIRST_ROWS.get(tabName);
				final Mapping classMapping = MAPPINGS.get(tabName);
				List<Map<String, String>> list = ExcelUtils.processTab(sheet, firstRow);
				processedTabs.add(new ProcessedTab(classMapping, list));
			}*/
		//}
	}
	
	public List<ProcessedTab> getProcessedTabs() {
		return this.processedTabs;
	}
	
	public class ProcessedTab {
		private Mapping classMapping;
		private List<Map<String, String>> tabData;
		public ProcessedTab(Mapping classMapping, List<Map<String, String>> tabData) {
			this.classMapping = classMapping;
			this.tabData = tabData;
		}
		public Mapping getClassMapping() {
			return classMapping;
		}
		public List<Map<String, String>> getTabData() {
			return tabData;
		}
	}
}
